/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.functional;

import java.util.Arrays;
import java.util.Collection;
import org.custommonkey.xmlunit.XMLAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.MuleClient;
import org.mule.module.xml.functional.AbstractXmlFunctionalTestCase;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.w3c.dom.Document;

public class XmlTransformerFunctionalTestCase
extends AbstractXmlFunctionalTestCase {
    public static final String SIMPLE_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<parent><child name=\"poot\"/></parent>";
    public static final String CHILDLESS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<parent/>";
    public static final String SERIALIZED = "<org.mule.module.xml.functional.XmlTransformerFunctionalTestCase_-Parent>\n  <child/>\n</org.mule.module.xml.functional.XmlTransformerFunctionalTestCase_-Parent>";

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/module/xml/xml-transformer-functional-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/module/xml/xml-transformer-functional-test-flow.xml"});
    }

    public XmlTransformerFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected MuleClient sendXml() throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("xml-in", (Object)SIMPLE_XML, null);
        return client;
    }

    protected MuleClient sendObject() throws MuleException {
        return this.sendObject("object-in");
    }

    protected MuleClient sendObject(String endpoint) throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch(endpoint, (Object)new Parent(new Child()), null);
        return client;
    }

    @Test
    public void testXmlOut() throws Exception {
        String xml = (String)this.request(this.sendXml(), "xml-out", String.class);
        XMLAssert.assertXMLEqual((String)SIMPLE_XML, (String)xml);
    }

    @Test
    public void testXmlDomOut() throws MuleException {
        Document dom = (Document)this.request(this.sendXml(), "xml-dom-out", Document.class);
        Assert.assertEquals((Object)"parent", (Object)dom.getDocumentElement().getLocalName());
    }

    @Test
    public void testXmlXsltOut() throws Exception {
        String xml = (String)this.request(this.sendXml(), "xml-xslt-out-string", String.class);
        XMLAssert.assertXMLEqual((String)CHILDLESS_XML, (String)xml);
    }

    @Test
    public void testDomXmlOut() throws Exception {
        String xml = (String)this.request(this.sendXml(), "dom-xml-out", String.class);
        XMLAssert.assertXMLEqual((String)SIMPLE_XML, (String)xml);
    }

    @Test
    public void testObjectOut() throws Exception {
        this.request(this.sendObject(), "object-out", Parent.class);
    }

    @Test
    public void testObjectXmlOut() throws Exception {
        String xml = (String)this.request(this.sendObject(), "object-xml-out", String.class);
        System.out.println(xml);
        XMLAssert.assertXMLEqual((String)SERIALIZED, (String)xml);
    }

    @Test
    public void testXmlJxpathOut() throws Exception {
        String xml = (String)this.request(this.sendXml(), "xml-jxpath-out", String.class);
        Assert.assertEquals((Object)"1", (Object)xml);
    }

    protected Object request(MuleClient client, String endpoint, Class<?> clazz) throws MuleException {
        MuleMessage message = client.request(endpoint, 3000L);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getPayload());
        Assert.assertTrue((String)message.getPayload().getClass().getName(), (boolean)clazz.isAssignableFrom(message.getPayload().getClass()));
        return message.getPayload();
    }

    public static class Child {
    }

    public static class Parent {
        private Child child;

        public Parent() {
            this(null);
        }

        public Parent(Child child) {
            this.setChild(child);
        }

        public Child getChild() {
            return this.child;
        }

        public void setChild(Child child) {
            this.child = child;
        }
    }
}

