/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.functional;

import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.ForceXalanTransformerFactory;
import org.mule.tck.junit4.rule.SystemProperty;

public class XsltWithParamsTransformerTestCase
extends FunctionalTestCase {
    @Rule
    public SystemProperty useXalan = new ForceXalanTransformerFactory();

    protected String getConfigFile() {
        return "org/mule/module/xml/xml-namespace-test.xml";
    }

    @Test
    public void testTransformWithParameter() throws Exception {
        Transformer trans = muleContext.getRegistry().lookupTransformer("test1");
        Assert.assertNotNull((Object)trans);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"<testing/>", muleContext);
        message.setOutboundProperty("Welcome", (Object)"hello");
        Object result = trans.transform((Object)message);
        Assert.assertNotNull((Object)result);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLAssert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><echo-value xmlns=\"http://test.com\">hello</echo-value>", (Object)result);
    }
}

