/*
 * Decompiled with CFR 0.152.
 */
package org.mule.properties;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.service.Service;
import org.mule.api.transport.PropertyScope;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.vm.VMMessageDispatcher;

public class SessionPropertiesTestCase
extends FunctionalTestCase {
    @Test
    public void setSessionPropertyUsingAPIGetInFlow() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, SessionPropertiesTestCase.getTestInboundEndpoint((String)""), (FlowConstruct)SessionPropertiesTestCase.getTestService());
        message.setProperty("key", (Object)"value", PropertyScope.SESSION);
        Flow flowA = (Flow)muleContext.getRegistry().lookupFlowConstruct("A");
        MuleEvent result = flowA.process((MuleEvent)event);
        Assert.assertEquals((Object)"value", (Object)result.getMessageAsString());
    }

    @Test
    public void setSessionPropertyInFlowGetUsingAPI() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, SessionPropertiesTestCase.getTestInboundEndpoint((String)""), (FlowConstruct)SessionPropertiesTestCase.getTestService());
        Flow flowA = (Flow)muleContext.getRegistry().lookupFlowConstruct("B");
        MuleEvent result = flowA.process((MuleEvent)event);
        Assert.assertEquals((Object)"value", (Object)result.getMessage().getProperty("key", PropertyScope.SESSION));
    }

    @Test
    public void propagateSessionPropertyOverTransportRequestResponse() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, SessionPropertiesTestCase.getTestInboundEndpoint((String)""), (FlowConstruct)SessionPropertiesTestCase.getTestService());
        Object nonSerializable = new Object();
        message.setProperty("key", (Object)"value", PropertyScope.SESSION);
        message.setProperty("keyNonSerializable", nonSerializable, PropertyScope.SESSION);
        Flow flowA = (Flow)muleContext.getRegistry().lookupFlowConstruct("RequestResponseSessionPropertySettingChain");
        MuleEvent result = flowA.process((MuleEvent)event);
        Assert.assertEquals((Object)"value", (Object)result.getMessage().getProperty("key", PropertyScope.SESSION));
        Assert.assertEquals((Object)"value1", (Object)result.getMessage().getProperty("key1", PropertyScope.SESSION));
        Assert.assertEquals((Object)"value2", (Object)result.getMessage().getProperty("key2", PropertyScope.SESSION));
        Assert.assertEquals((Object)"value3", (Object)result.getMessage().getProperty("key3", PropertyScope.SESSION));
        Assert.assertEquals((Object)"value4", (Object)result.getMessage().getProperty("key4", PropertyScope.SESSION));
        Assert.assertEquals((Object)"value5", (Object)result.getMessage().getProperty("key5", PropertyScope.SESSION));
        Assert.assertEquals((Object)nonSerializable, (Object)result.getMessage().getProperty("keyNonSerializable", PropertyScope.SESSION));
    }

    @Test
    public void propagateSessionPropertyOverTransportOneWay() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, SessionPropertiesTestCase.getTestInboundEndpoint((String)""), (FlowConstruct)SessionPropertiesTestCase.getTestService());
        Object nonSerializable = new Object();
        message.setProperty("key", (Object)"value", PropertyScope.SESSION);
        message.setProperty("keyNonSerializable", nonSerializable, PropertyScope.SESSION);
        Flow flowA = (Flow)muleContext.getRegistry().lookupFlowConstruct("OneWaySessionPropertySettingChain");
        flowA.process((MuleEvent)event);
        MuleMessage out = muleContext.getClient().request("vm://H-out?connector=VMConnector", 5000L);
        Assert.assertNotNull((Object)out);
        Assert.assertEquals((Object)"value", (Object)out.getProperty("key", PropertyScope.SESSION));
        Assert.assertEquals((Object)"value1", (Object)out.getProperty("key1", PropertyScope.SESSION));
        Assert.assertEquals((Object)"value2", (Object)out.getProperty("key2", PropertyScope.SESSION));
        Assert.assertNull((Object)out.getProperty("keyNonSerializable", PropertyScope.SESSION));
    }

    @Test
    public void nonSerializableSessionPropertyOneWayFlow() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, SessionPropertiesTestCase.getTestInboundEndpoint((String)""), (FlowConstruct)SessionPropertiesTestCase.getTestService());
        Object nonSerializable = new Object();
        message.setProperty("keyNonSerializable", nonSerializable, PropertyScope.SESSION);
        Flow flow = (Flow)muleContext.getRegistry().lookupFlowConstruct("PassthroughFlow");
        flow.process((MuleEvent)event);
        MuleMessage out = muleContext.getClient().request("vm://PassthroughFlow-out?connector=VMConnector", 5000L);
        Assert.assertNotNull((Object)out);
        Assert.assertNull((Object)out.getProperty("keyNonSerializable", PropertyScope.SESSION));
    }

    @Test
    public void flowRefSessionPropertyPropagation() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, SessionPropertiesTestCase.getTestInboundEndpoint((String)""), (FlowConstruct)SessionPropertiesTestCase.getTestService());
        Object nonSerializable = new Object();
        message.setProperty("keyNonSerializable", nonSerializable, PropertyScope.SESSION);
        message.setProperty("key", (Object)"value", PropertyScope.SESSION);
        Flow flow = (Flow)muleContext.getRegistry().lookupFlowConstruct("FlowRefWithSessionProperties");
        MuleEvent result = flow.process((MuleEvent)event);
        Assert.assertSame((Object)event.getSession(), (Object)result.getSession());
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"value", (Object)result.getMessage().getProperty("key", PropertyScope.SESSION));
        Assert.assertEquals((Object)"value1", (Object)result.getMessage().getProperty("key1", PropertyScope.SESSION));
        Assert.assertEquals((Object)"value2", (Object)result.getMessage().getProperty("key2", PropertyScope.SESSION));
        Assert.assertEquals((Object)nonSerializable, (Object)result.getMessage().getProperty("keyNonSerializable", PropertyScope.SESSION));
    }

    @Test
    public void outboundEndpointSessionMerge() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, SessionPropertiesTestCase.getTestInboundEndpoint((String)""), (FlowConstruct)SessionPropertiesTestCase.getTestService());
        Object nonSerializable = new Object();
        message.setProperty("keyNonSerializable", nonSerializable, PropertyScope.SESSION);
        message.setProperty("keyNonSerializable2", nonSerializable, PropertyScope.SESSION);
        message.setProperty("key", (Object)"value", PropertyScope.SESSION);
        message.setProperty("key2", (Object)"value2", PropertyScope.SESSION);
        VMMessageDispatcher dispatcher = new VMMessageDispatcher(muleContext.getEndpointFactory().getOutboundEndpoint("addSessionPropertiesFlowEndpoint"));
        MuleEvent result = dispatcher.process((MuleEvent)event);
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((Object)event, (Object)result);
        Assert.assertEquals((Object)"val", (Object)result.getSession().getProperty("keyNonSerializable"));
        Assert.assertEquals((Object)nonSerializable, (Object)result.getSession().getProperty("keyNonSerializable2"));
        Assert.assertEquals((Object)"value2NEW", (Object)result.getSession().getProperty("key2"));
        Assert.assertEquals((Object)"value3", (Object)result.getSession().getProperty("key3"));
        Assert.assertNull((Object)result.getMessage().getProperty("nonSerializableBean"));
    }

    @Test
    public void requestReplySessionMerge() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, SessionPropertiesTestCase.getTestInboundEndpoint((String)""), (FlowConstruct)SessionPropertiesTestCase.getTestService());
        Object nonSerializable = new Object();
        message.setProperty("keyNonSerializable", nonSerializable, PropertyScope.SESSION);
        message.setProperty("keyNonSerializable2", nonSerializable, PropertyScope.SESSION);
        message.setProperty("key", (Object)"value", PropertyScope.SESSION);
        message.setProperty("key2", (Object)"value2", PropertyScope.SESSION);
        MuleEvent result = ((Flow)muleContext.getRegistry().lookupFlowConstruct("requestResponseFlow")).process((MuleEvent)event);
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((Object)event, (Object)result);
        Assert.assertEquals((Object)"val", (Object)result.getSession().getProperty("keyNonSerializable"));
        Assert.assertEquals((Object)nonSerializable, (Object)result.getSession().getProperty("keyNonSerializable2"));
        Assert.assertEquals((Object)"value2NEW", (Object)result.getSession().getProperty("key2"));
        Assert.assertEquals((Object)"value3", (Object)result.getSession().getProperty("key3"));
        Assert.assertNull((Object)result.getSession().getProperty("nonSerializableBean"));
    }

    @Test
    public void requestReplyNoSessionPropagationSessionMerge() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, SessionPropertiesTestCase.getTestInboundEndpoint((String)""), SessionPropertiesTestCase.getTestSession((Service)SessionPropertiesTestCase.getTestService(), (MuleContext)muleContext));
        Object nonSerializable = new Object();
        event.getSession().setProperty("keyNonSerializable", nonSerializable);
        event.getSession().setProperty("keyNonSerializable2", nonSerializable);
        event.getSession().setProperty("key", (Serializable)((Object)"value"));
        event.getSession().setProperty("key2", (Serializable)((Object)"value2"));
        MuleEvent result = ((Flow)muleContext.getRegistry().lookupFlowConstruct("requestResponseNoSessionPropagationFlow")).process((MuleEvent)event);
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((Object)event, (Object)result);
        Assert.assertEquals((Object)nonSerializable, (Object)result.getSession().getProperty("keyNonSerializable"));
        Assert.assertEquals((Object)nonSerializable, (Object)result.getSession().getProperty("keyNonSerializable2"));
        Assert.assertEquals((Object)"value", (Object)result.getSession().getProperty("key"));
        Assert.assertEquals((Object)"value2", (Object)result.getSession().getProperty("key2"));
        Assert.assertNull((Object)result.getSession().getProperty("nonSerializableBean"));
    }

    @Test
    public void defaultExceptionStrategy() throws Exception {
        this.testFlow("defaultExceptionStrategy");
    }

    @Test
    public void catchExceptionStrategy() throws Exception {
        this.testFlow("catchExceptionStrategy");
    }

    protected String getConfigFile() {
        return "org/mule/properties/session-properties-config.xml";
    }
}

