/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.store.ObjectStoreException;
import org.mule.routing.AggregationException;
import org.mule.routing.EventGroup;
import org.mule.routing.SimpleCollectionAggregator;
import org.mule.routing.correlation.CollectionCorrelatorCallback;
import org.mule.routing.correlation.EventCorrelatorCallback;
import org.mule.tck.junit4.FunctionalTestCase;

public class AggregationTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/routing/outbound/aggregation-config.xml";
    }

    @Test
    public void testCollectionAggregator() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        String payload = "Long string that wil be broken uop into multiple messages";
        client.dispatch("vm://in", (Object)payload, null);
        MuleMessage msg = client.request("vm://collectionCreated", 5000L);
        Assert.assertNotNull((Object)msg);
        Assert.assertTrue((boolean)(msg instanceof MuleMessageCollection));
        MuleMessageCollection collection = (MuleMessageCollection)msg;
        List chunks = (List)collection.getPayload();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (byte[] chunk : chunks) {
            baos.write(chunk);
        }
        String aggregated = baos.toString();
        Assert.assertEquals((Object)payload, (Object)aggregated);
    }

    @Test
    public void testCustomAggregator() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        String payload = "Long string that wil be broken uop into multiple messages";
        client.dispatch("vm://in2", (Object)payload, null);
        MuleMessage msg = client.request("vm://collectionCreated2", 5000L);
        Assert.assertNotNull((Object)msg);
        Assert.assertNotNull((Object)msg.getPayload());
        Assert.assertTrue((boolean)(msg.getPayload() instanceof List));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (Object obj : (List)msg.getPayload()) {
            Assert.assertTrue((boolean)(obj instanceof MuleEvent));
            MuleEvent event = (MuleEvent)obj;
            Assert.assertTrue((boolean)(event.getMessage().getPayload() instanceof byte[]));
            baos.write((byte[])event.getMessage().getPayload());
        }
        String aggregated = baos.toString();
        Assert.assertEquals((Object)payload, (Object)aggregated);
    }

    static class MyCollectionCorrelatorCallback
    extends CollectionCorrelatorCallback {
        public MyCollectionCorrelatorCallback(MuleContext muleContext, boolean persistentStores, String storePrefix) {
            super(muleContext, persistentStores, storePrefix);
        }

        public MuleEvent aggregateEvents(EventGroup events) throws AggregationException {
            ArrayList<MuleEvent> eventList = new ArrayList<MuleEvent>();
            Iterator iter = null;
            FlowConstruct fc = null;
            try {
                iter = events.iterator(true);
            }
            catch (ObjectStoreException e) {
                throw new AggregationException(events, null, (Throwable)e);
            }
            while (iter.hasNext()) {
                MuleEvent event = (MuleEvent)iter.next();
                eventList.add(event);
                fc = event.getFlowConstruct();
            }
            DefaultMuleMessage msg = new DefaultMuleMessage(eventList, this.muleContext);
            return new DefaultMuleEvent((MuleMessage)msg, MessageExchangePattern.ONE_WAY, fc);
        }
    }

    public static class Aggregator
    extends SimpleCollectionAggregator {
        protected EventCorrelatorCallback getCorrelatorCallback(MuleContext context) {
            return new MyCollectionCorrelatorCallback(context, this.persistentStores, this.storePrefix);
        }
    }
}

