/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.FunctionalTestCase;

public class ChainingRouterPropertyPropagationTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/routing/outbound/chaining-router-properties-propagation-config.xml";
    }

    @Test
    public void testPropertiesPropagation() throws Exception {
        FunctionalTestComponent hop1 = this.getFunctionalTestComponent("hop1Service");
        FunctionalTestComponent hop2 = this.getFunctionalTestComponent("hop2Service");
        Assert.assertNotNull((Object)hop1);
        final AtomicBoolean hop1made = new AtomicBoolean(false);
        EventCallback callback1 = new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                Assert.assertTrue((boolean)hop1made.compareAndSet(false, true));
                FunctionalTestComponent ftc = (FunctionalTestComponent)component;
                ftc.setReturnData((Object)"Hop1 ACK");
            }
        };
        final AtomicBoolean hop2made = new AtomicBoolean(false);
        EventCallback callback2 = new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                MuleMessage msg = context.getMessage();
                Assert.assertTrue((boolean)hop2made.compareAndSet(false, true));
                Assert.assertEquals((String)"Property not propagated from the first hop.", (Object)"hop1", (Object)msg.getInboundProperty("TICKET"));
                FunctionalTestComponent ftc = (FunctionalTestComponent)component;
                ftc.setReturnData((Object)(msg.getPayload() + " Hop2 ACK"));
            }
        };
        hop1.setEventCallback(callback1);
        hop2.setEventCallback(callback2);
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"payload", muleContext);
        MuleMessage reply = client.send("inboundEndpoint", (MuleMessage)request);
        Assert.assertNotNull((Object)reply);
        Assert.assertTrue((String)"First callback never fired", (boolean)hop1made.get());
        Assert.assertTrue((String)"Second callback never fired", (boolean)hop2made.get());
        Assert.assertEquals((Object)"Hop1 ACK Hop2 ACK", (Object)reply.getPayload());
        Assert.assertEquals((Object)"hop1", (Object)reply.getInboundProperty("TICKET"));
        Assert.assertEquals((Object)"10000", (Object)reply.getInboundProperty("TTL"));
    }
}

