/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.io.ByteArrayInputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.routing.RoutingException;
import org.mule.message.ExceptionMessage;
import org.mule.tck.junit4.FunctionalTestCase;

public class MulticastRouterTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/routing/outbound/multicasting-router-config.xml";
    }

    @Test
    public void testAll() throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream("Hello, world".getBytes("UTF-8"));
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://inbound1", (Object)bis, null);
        MuleMessage response = client.request("vm://output1", 2000L);
        Assert.assertNull((Object)response);
        MuleMessage error = client.request("vm://errors", 2000L);
        this.assertRoutingExceptionReceived(error);
    }

    @Test
    public void testFirstSuccessful() throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream("Hello, world".getBytes("UTF-8"));
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://inbound2", (Object)bis, null);
        MuleMessage response = client.request("vm://output4", 2000L);
        Assert.assertNull((Object)response);
        MuleMessage error = client.request("vm://errors2", 2000L);
        this.assertRoutingExceptionReceived(error);
    }

    private void assertRoutingExceptionReceived(MuleMessage message) {
        Assert.assertNotNull((Object)message);
        Object payload = message.getPayload();
        Assert.assertNotNull((Object)payload);
        Assert.assertTrue((boolean)(payload instanceof ExceptionMessage));
        ExceptionMessage exceptionMessage = (ExceptionMessage)payload;
        Assert.assertTrue((boolean)(exceptionMessage.getException() instanceof RoutingException));
    }
}

