/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.EncryptionStrategy;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.security.MuleCredentials;
import org.mule.session.MuleSessionHandler;
import org.mule.tck.AbstractServiceAndFlowTestCase;

@Ignore
public class MultiuserSecurityTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "multiuser-security-test-service.xml, singleuser-security-provider.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "multiuser-security-test-flow.xml, singleuser-security-provider.xml"});
    }

    public MultiuserSecurityTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testMultipleAuthentications() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleSessionHandler sessionHandler = new MuleSessionHandler();
        EncryptionStrategy strategy = muleContext.getSecurityManager().getEncryptionStrategy("PBE");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("MULE_USER", MuleCredentials.createHeader((String)"marie", (String)"marie", (String)"PBE", (EncryptionStrategy)strategy));
        MuleMessage reply = client.send("vm://test", (Object)"Data1", props);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"user = marie, logins = 1, color = bright red", (Object)reply.getPayload());
        props = new HashMap();
        props.put("MULE_USER", MuleCredentials.createHeader((String)"stan", (String)"stan", (String)"PBE", (EncryptionStrategy)strategy));
        reply = client.send("vm://test", (Object)"Data2", props);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"user = stan, logins = 1, color = metallic blue", (Object)reply.getPayload());
        props = new HashMap();
        props.put("MULE_USER", MuleCredentials.createHeader((String)"cindy", (String)"cindy", (String)"PBE", (EncryptionStrategy)strategy));
        reply = client.send("vm://test", (Object)"Data3", props);
        Assert.assertEquals((Object)"user = cindy, logins = 1, color = dark violet", (Object)reply.getPayload());
        props = new HashMap();
        props.put("MULE_USER", MuleCredentials.createHeader((String)"marie", (String)"marie", (String)"PBE", (EncryptionStrategy)strategy));
        reply = client.send("vm://test", (Object)"Data4", props);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"user = marie, logins = 2, color = bright red", (Object)reply.getPayload());
        props = new HashMap();
        props.put("MULE_USER", MuleCredentials.createHeader((String)"marie", (String)"marie", (String)"PBE", (EncryptionStrategy)strategy));
        reply = client.send("vm://test", (Object)"Data4", props);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"user = marie, logins = 3, color = bright red", (Object)reply.getPayload());
        props = new HashMap();
        props.put("MULE_USER", MuleCredentials.createHeader((String)"stan", (String)"stan", (String)"PBE", (EncryptionStrategy)strategy));
        reply = client.send("vm://test", (Object)"Data2", props);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"user = stan, logins = 2, color = metallic blue", (Object)reply.getPayload());
    }
}

