/*
 * Decompiled with CFR 0.152.
 */
package org.mule.shutdown;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.MuleClient;
import org.mule.shutdown.AbstractShutdownTimeoutRequestResponseTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

public class ValidShutdownTimeoutRequestResponseTestCase
extends AbstractShutdownTimeoutRequestResponseTestCase {
    @Rule
    public SystemProperty contextShutdownTimeout = new SystemProperty("contextShutdownTimeout", "5000");

    protected boolean isGracefulShutdown() {
        return true;
    }

    protected String getConfigFile() {
        return "shutdown-timeout-request-response-config.xml";
    }

    @Test
    public void testStaticComponent() throws Exception {
        this.doShutDownTest("staticComponentResponse", "http://localhost:" + this.httpPort.getNumber() + "/staticComponent");
    }

    @Test
    public void testScriptComponent() throws Exception {
        this.doShutDownTest("scriptComponentResponse", "http://localhost:" + this.httpPort.getNumber() + "/scriptComponent");
    }

    @Test
    public void testExpressionTransformer() throws Exception {
        this.doShutDownTest("expressionTransformerResponse", "http://localhost:" + this.httpPort.getNumber() + "/expressionTransformer");
    }

    private void doShutDownTest(final String payload, String url) throws MuleException, InterruptedException {
        LocalMuleClient client = muleContext.getClient();
        boolean[] results = new boolean[]{false};
        Thread t = new Thread((MuleClient)client, url, results){
            final /* synthetic */ MuleClient val$client;
            final /* synthetic */ String val$url;
            final /* synthetic */ boolean[] val$results;
            {
                this.val$client = muleClient;
                this.val$url = string2;
                this.val$results = blArray;
            }

            @Override
            public void run() {
                try {
                    DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)payload, new HashMap(), muleContext);
                    MuleMessage result = this.val$client.send(this.val$url, (MuleMessage)muleMessage);
                    this.val$results[0] = payload.equals(result.getPayloadAsString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        waitLatch.await();
        muleContext.stop();
        t.join();
        Assert.assertTrue((String)"Was not able to process message ", (boolean)results[0]);
    }
}

