/*
 * Decompiled with CFR 0.152.
 */
package org.mule.spring.config;

import java.io.IOException;
import java.util.Map;
import java.util.ServiceLoader;
import junit.framework.Assert;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Test;
import org.mule.common.MuleArtifact;
import org.mule.common.MuleArtifactFactoryException;
import org.mule.common.Testable;
import org.mule.common.config.XmlConfigurationCallback;
import org.mule.common.config.XmlConfigurationMuleArtifactFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class UnsupportedConnectorsMuleArtifactTestCase {
    @Test
    public void unsupportedConnectors() throws SAXException, IOException, MuleArtifactFactoryException {
        this.checkUnsupportedConnector("<http:connector name=\"HttpConnector\" xmlns:http=\"http://www.mulesoft.org/schema/mule/http\"/>");
        this.checkUnsupportedConnector("<http:polling-connector name=\"PollingHttpConnector\"\n        pollingFrequency=\"30000\" reuseAddress=\"true\" xmlns:http=\"http://www.mulesoft.org/schema/mule/http\"/>");
        this.checkUnsupportedConnector("<https:connector name=\"httpConnector\" xmlns:https=\"http://www.mulesoft.org/schema/mule/https\">\n        <https:tls-key-store path=\"~/ce/tests/integration/src/test/resources/muletest.keystore\" keyPassword=\"mulepassword\" storePassword=\"mulepassword\"/>\n</https:connector>");
        this.checkUnsupportedConnector("<jms:activemq-connector name=\"Active_MQ\" brokerURL=\"vm://localhost\" validateConnections=\"true\" xmlns:jms=\"http://www.mulesoft.org/schema/mule/jms\"/>");
        this.checkUnsupportedConnector("<ftp:connector name=\"ftpConnector\" streaming=\"true\" xmlns:ftp=\"http://www.mulesoft.org/schema/mule/ftp\"/>");
        this.checkUnsupportedConnector("<sftp:connector name=\"sftp-default\" xmlns:sftp=\"http://www.mulesoft.org/schema/mule/sftp\"/>");
        this.checkUnsupportedConnector("<file:connector name=\"output\" outputAppend=\"false\" outputPattern=\"#[function:datestamp]-#[header:inbound:originalFilename]\" xmlns:file=\"http://www.mulesoft.org/schema/mule/file\"/>\n");
        this.checkUnsupportedConnector("<file:connector name=\"input\" fileAge=\"500\" autoDelete=\"true\" pollingFrequency=\"100\" moveToDirectory=\"/backup\" moveToPattern=\"#[header:inbound:originalFilename].backup\" xmlns:file=\"http://www.mulesoft.org/schema/mule/file\"/>\n");
        this.checkUnsupportedConnector("<vm:connector name=\"memory\" xmlns:vm=\"http://www.mulesoft.org/schema/mule/vm\"/>");
    }

    private void checkUnsupportedConnector(String connectorConfig) throws IOException, SAXException, MuleArtifactFactoryException {
        Document document = XMLUnit.buildControlDocument((String)connectorConfig);
        MuleArtifact artifact = UnsupportedConnectorsMuleArtifactTestCase.lookupArtifact().getArtifact((Object)document.getDocumentElement(), (Object)this.getXmlConfigurationCallbackForUnsupportedConnector());
        Assert.assertNotNull((Object)artifact);
        Assert.assertFalse((boolean)artifact.hasCapability(Testable.class));
        Assert.assertEquals((Object)artifact.getCapability(Testable.class), null);
    }

    private XmlConfigurationCallback getXmlConfigurationCallbackForUnsupportedConnector() {
        return new XmlConfigurationCallback(){

            public Element getGlobalElement(String s) {
                return null;
            }

            public String getSchemaLocation(String s) {
                if (s != null) {
                    int connectorNameStart = s.lastIndexOf("/") + 1;
                    s = s + "/current/mule-" + s.substring(connectorNameStart) + ".xsd";
                    return s;
                }
                return null;
            }

            public Element[] getPropertyPlaceholders() {
                return new Element[0];
            }

            public Map<String, String> getEnvironmentProperties() {
                return null;
            }
        };
    }

    protected static XmlConfigurationMuleArtifactFactory lookupArtifact() {
        return ServiceLoader.load(XmlConfigurationMuleArtifactFactory.class).iterator().next();
    }
}

