/*
 * Decompiled with CFR 0.152.
 */
package org.mule.spring.config;

import java.util.Map;
import java.util.ServiceLoader;
import junit.framework.Assert;
import org.custommonkey.xmlunit.XMLUnit;
import org.mule.common.MuleArtifact;
import org.mule.common.MuleArtifactFactoryException;
import org.mule.common.Result;
import org.mule.common.Testable;
import org.mule.common.config.XmlConfigurationCallback;
import org.mule.common.config.XmlConfigurationMuleArtifactFactory;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class XmlConfigurationMuleArtifactFactoryTestCase
extends AbstractMuleTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTestMessageProcessorArtifactRetrieval(Document document, XmlConfigurationCallback callback) throws MuleArtifactFactoryException {
        XmlConfigurationMuleArtifactFactory factory = XmlConfigurationMuleArtifactFactoryTestCase.lookupArtifact();
        MuleArtifact artifact = null;
        try {
            artifact = factory.getArtifactForMessageProcessor((Object)document.getDocumentElement(), (Object)callback);
            Assert.assertNotNull((Object)artifact);
        }
        finally {
            if (artifact != null) {
                factory.returnArtifact(artifact);
            }
        }
    }

    protected void doTestMessageProcessorCapabilities(Document document, XmlConfigurationCallback callback) throws MuleArtifactFactoryException {
        this.doTestMessageProcessor(document, callback, null);
    }

    protected void doTestMessageProcessor(Document document, XmlConfigurationCallback callback) throws MuleArtifactFactoryException {
        this.doTestMessageProcessor(document, callback, Result.Status.SUCCESS);
    }

    protected void doTest(Document document, XmlConfigurationCallback callback) throws MuleArtifactFactoryException {
        this.doTest(document, callback, Result.Status.SUCCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestMessageProcessor(Document document, XmlConfigurationCallback callback, Result.Status expectedResult) throws MuleArtifactFactoryException {
        XmlConfigurationMuleArtifactFactory factory = XmlConfigurationMuleArtifactFactoryTestCase.lookupArtifact();
        MuleArtifact artifact = null;
        try {
            artifact = factory.getArtifactForMessageProcessor((Object)document.getDocumentElement(), (Object)callback);
            Assert.assertNotNull((Object)artifact);
            Assert.assertTrue((boolean)artifact.hasCapability(OperationMetaDataEnabled.class));
            Assert.assertTrue((boolean)(artifact.getCapability(OperationMetaDataEnabled.class) instanceof OperationMetaDataEnabled));
            if (expectedResult != null) {
                OperationMetaDataEnabled artifactCapability = (OperationMetaDataEnabled)artifact.getCapability(OperationMetaDataEnabled.class);
                Assert.assertNull((Object)artifactCapability.getInputMetaData());
                Assert.assertEquals((Object)expectedResult, (Object)artifactCapability.getOutputMetaData(null).getStatus());
            }
        }
        finally {
            if (artifact != null) {
                factory.returnArtifact(artifact);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(Document document, XmlConfigurationCallback callback, Result.Status expectedResult) throws MuleArtifactFactoryException {
        XmlConfigurationMuleArtifactFactory factory = XmlConfigurationMuleArtifactFactoryTestCase.lookupArtifact();
        MuleArtifact artifact = null;
        try {
            artifact = factory.getArtifact((Object)document.getDocumentElement(), (Object)callback);
            Assert.assertNotNull((Object)artifact);
            Assert.assertTrue((boolean)artifact.hasCapability(Testable.class));
            Assert.assertTrue((boolean)(artifact.getCapability(Testable.class) instanceof Testable));
            if (expectedResult != null) {
                Testable artifactCapability = (Testable)artifact.getCapability(Testable.class);
                Assert.assertEquals((Object)expectedResult, (Object)artifactCapability.test().getStatus());
            }
        }
        finally {
            if (artifact != null) {
                factory.returnArtifact(artifact);
            }
        }
    }

    protected static XmlConfigurationMuleArtifactFactory lookupArtifact() {
        return ServiceLoader.load(XmlConfigurationMuleArtifactFactory.class).iterator().next();
    }

    protected static class MapXmlConfigurationCallback
    implements XmlConfigurationCallback {
        private Map<String, String> refNameToXml;
        private Map<String, String> namespaceUriToSchemaLocation;

        public MapXmlConfigurationCallback() {
            this(null, null);
        }

        public MapXmlConfigurationCallback(Map<String, String> refNameToXml, Map<String, String> namespaceUriToSchemaLocation) {
            this.refNameToXml = refNameToXml;
            this.namespaceUriToSchemaLocation = namespaceUriToSchemaLocation;
        }

        public Element getGlobalElement(String globalElementName) {
            String xml;
            if (this.refNameToXml != null && (xml = this.refNameToXml.get(globalElementName)) != null) {
                try {
                    return XMLUnit.buildControlDocument((String)xml).getDocumentElement();
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        }

        public String getSchemaLocation(String namespaceUri) {
            if (this.namespaceUriToSchemaLocation != null) {
                return this.namespaceUriToSchemaLocation.get(namespaceUri);
            }
            return null;
        }

        public Element[] getPropertyPlaceholders() {
            return new Element[0];
        }

        public Map<String, String> getEnvironmentProperties() {
            return null;
        }
    }
}

