/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class NoArgsCallWrapperFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    private static final int RECEIVE_TIMEOUT = 5000;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "no-args-call-wrapper-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "no-args-call-wrapper-config-flow.xml"});
    }

    public NoArgsCallWrapperFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testNoArgsCallWrapper() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://invoke", (Object)"test", null);
        MuleMessage reply = client.request("vm://out", 5000L);
        Assert.assertNotNull((Object)reply);
        Assert.assertNull((Object)reply.getExceptionPayload());
        Assert.assertEquals((Object)"Just an apple.", (Object)reply.getPayload());
    }

    @Test
    public void testWithInjectedDelegate() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://invokeWithInjected", (Object)"test", null);
        MuleMessage reply = client.request("vm://outWithInjected", 5000L);
        Assert.assertNotNull((Object)reply);
        Assert.assertNull((Object)reply.getExceptionPayload());
        Assert.assertEquals((Object)"test", (Object)reply.getPayload());
    }
}

