/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.message.DefaultExceptionPayload;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class EntryPointResolverCacheTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/components/entry-point-resolver-cache-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/components/entry-point-resolver-cache-flow.xml"});
    }

    public EntryPointResolverCacheTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testCache() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = null;
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put("method", "retrieveReferenceData");
        response = client.send("refOneInbound", (Object)"a request", propertyMap);
        Object payload = response.getPayload();
        Assert.assertTrue((String)"should be a string", (boolean)(payload instanceof String));
        Assert.assertEquals((Object)"ServiceOne", (Object)payload);
        response = client.send("refTwoInbound", (Object)"another request", propertyMap);
        payload = response.getPayload();
        if (payload == null || response.getExceptionPayload() != null) {
            DefaultExceptionPayload exPld = (DefaultExceptionPayload)response.getExceptionPayload();
            if (exPld.getException() != null) {
                Assert.fail((String)exPld.getException().getMessage());
            } else {
                Assert.fail((String)exPld.toString());
            }
        }
        Assert.assertTrue((String)"should be a string", (boolean)(payload instanceof String));
        Assert.assertEquals((Object)"ServiceTwo", (Object)payload);
    }

    public static class RefDataServiceTwo
    implements ReferenceDataService {
        @Override
        public String retrieveReferenceData(String refKey) {
            return "ServiceTwo";
        }
    }

    public static class RefDataServiceOne
    implements ReferenceDataService {
        @Override
        public String retrieveReferenceData(String refKey) {
            return "ServiceOne";
        }
    }

    public static interface ReferenceDataService {
        public String retrieveReferenceData(String var1);
    }
}

