/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.MuleContextBuilder;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class MuleConfigurationTestCase
extends AbstractMuleTestCase {
    private boolean failOnMessageScribbling;
    protected String workingDirectory = "target";
    private MuleContext muleContext;

    @Before
    public void setUp() throws Exception {
        this.failOnMessageScribbling = ThreadSafeAccess.AccessControl.isFailOnMessageScribbling();
    }

    @After
    public void tearDown() throws Exception {
        this.muleContext.dispose();
        this.muleContext = null;
        ThreadSafeAccess.AccessControl.setFailOnMessageScribbling((boolean)this.failOnMessageScribbling);
    }

    @Test
    public void testConfigureProgramatically() throws Exception {
        DefaultMuleConfiguration config = new DefaultMuleConfiguration();
        config.setDefaultEncoding("UTF-16");
        config.setDefaultSynchronousEndpoints(true);
        config.setSystemModelType("direct");
        config.setDefaultResponseTimeout(30000);
        config.setDefaultTransactionTimeout(60000);
        config.setWorkingDirectory(this.workingDirectory);
        config.setClientMode(true);
        ThreadSafeAccess.AccessControl.setFailOnMessageScribbling((boolean)false);
        config.setId("MY_SERVER");
        config.setDomainId("MY_DOMAIN");
        config.setCacheMessageAsBytes(false);
        config.setCacheMessageOriginalPayload(false);
        config.setEnableStreaming(false);
        ThreadSafeAccess.AccessControl.setAssertMessageAccess((boolean)false);
        config.setAutoWrapMessageAwareTransform(false);
        DefaultMuleContextBuilder contextBuilder = new DefaultMuleContextBuilder();
        contextBuilder.setMuleConfiguration((MuleConfiguration)config);
        this.muleContext = new DefaultMuleContextFactory().createMuleContext((MuleContextBuilder)contextBuilder);
        this.muleContext.start();
        this.verifyConfiguration();
    }

    @Test
    public void testConfigureWithSystemProperties() throws Exception {
        System.setProperty("mule.encoding", "UTF-16");
        System.setProperty("mule.endpoints.synchronous", "true");
        System.setProperty("mule.systemModelType", "direct");
        System.setProperty("mule.timeout.synchronous", "30000");
        System.setProperty("mule.timeout.transaction", "60000");
        System.setProperty("mule.remoteSync", "true");
        System.setProperty("mule.workingDirectory", this.workingDirectory);
        System.setProperty("mule.clientMode", "true");
        ThreadSafeAccess.AccessControl.setFailOnMessageScribbling((boolean)false);
        System.setProperty("mule.serverId", "MY_SERVER");
        System.setProperty("mule.domainId", "MY_DOMAIN");
        System.setProperty("mule.message.cacheBytes", "false");
        System.setProperty("mule.message.cacheOriginal", "false");
        System.setProperty("mule.streaming.enable", "false");
        System.setProperty("mule.message.assertAccess", "false");
        System.setProperty("mule.transform.autoWrap", "false");
        this.muleContext = new DefaultMuleContextFactory().createMuleContext();
        this.muleContext.start();
        this.verifyConfiguration();
        System.clearProperty("mule.encoding");
        System.clearProperty("mule.endpoints.synchronous");
        System.clearProperty("mule.systemModelType");
        System.clearProperty("mule.timeout.synchronous");
        System.clearProperty("mule.timeout.transaction");
        System.clearProperty("mule.remoteSync");
        System.clearProperty("mule.workingDirectory");
        System.clearProperty("mule.clientMode");
        System.clearProperty("mule.disable.threadsafemessages");
        System.clearProperty("mule.serverId");
        System.clearProperty("mule.domainId");
        System.clearProperty("mule.message.cacheBytes");
        System.clearProperty("mule.message.cacheOriginal");
        System.clearProperty("mule.streaming.enable");
        System.clearProperty("mule.message.assertAccess");
        System.clearProperty("mule.transform.autoWrap");
    }

    @Test
    public void testConfigureAfterInitFails() throws Exception {
        this.muleContext = new DefaultMuleContextFactory().createMuleContext();
        DefaultMuleConfiguration mutableConfig = (DefaultMuleConfiguration)this.muleContext.getConfiguration();
        mutableConfig.setDefaultSynchronousEndpoints(true);
        mutableConfig.setSystemModelType("direct");
        mutableConfig.setDefaultResponseTimeout(30000);
        mutableConfig.setDefaultTransactionTimeout(60000);
        mutableConfig.setClientMode(true);
        mutableConfig.setDefaultEncoding("UTF-16");
        mutableConfig.setWorkingDirectory(this.workingDirectory);
        mutableConfig.setId("MY_SERVER");
        mutableConfig.setDomainId("MY_DOMAIN");
        MuleConfiguration config = this.muleContext.getConfiguration();
        Assert.assertEquals((Object)"direct", (Object)config.getSystemModelType());
        Assert.assertEquals((long)30000L, (long)config.getDefaultResponseTimeout());
        Assert.assertEquals((long)60000L, (long)config.getDefaultTransactionTimeout());
        Assert.assertTrue((boolean)config.isClientMode());
        Assert.assertFalse((boolean)"UTF-16".equals(config.getDefaultEncoding()));
        Assert.assertFalse((boolean)this.workingDirectory.equals(config.getWorkingDirectory()));
        Assert.assertFalse((boolean)"MY_SERVER".equals(config.getId()));
        Assert.assertFalse((boolean)"MY_DOMAIN".equals(config.getDomainId()));
    }

    @Test
    public void testConfigureAfterStartFails() throws Exception {
        this.muleContext = new DefaultMuleContextFactory().createMuleContext();
        this.muleContext.start();
        DefaultMuleConfiguration mutableConfig = (DefaultMuleConfiguration)this.muleContext.getConfiguration();
        mutableConfig.setDefaultSynchronousEndpoints(true);
        mutableConfig.setSystemModelType("direct");
        mutableConfig.setDefaultResponseTimeout(30000);
        mutableConfig.setDefaultTransactionTimeout(60000);
        mutableConfig.setClientMode(true);
        MuleConfiguration config = this.muleContext.getConfiguration();
        Assert.assertFalse((boolean)"direct".equals(config.getSystemModelType()));
        Assert.assertFalse((30000 == config.getDefaultResponseTimeout() ? 1 : 0) != 0);
        Assert.assertFalse((60000 == config.getDefaultTransactionTimeout() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)config.isClientMode());
    }

    protected void verifyConfiguration() {
        MuleConfiguration config = this.muleContext.getConfiguration();
        Assert.assertEquals((Object)"UTF-16", (Object)config.getDefaultEncoding());
        Assert.assertEquals((Object)"direct", (Object)config.getSystemModelType());
        Assert.assertEquals((long)30000L, (long)config.getDefaultResponseTimeout());
        Assert.assertEquals((long)60000L, (long)config.getDefaultTransactionTimeout());
        Assert.assertTrue((config.getWorkingDirectory().indexOf(this.workingDirectory) != -1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)config.isClientMode());
        Assert.assertFalse((boolean)ThreadSafeAccess.AccessControl.isFailOnMessageScribbling());
        Assert.assertEquals((Object)"MY_SERVER", (Object)config.getId());
        Assert.assertEquals((Object)"MY_DOMAIN", (Object)config.getDomainId());
        Assert.assertFalse((boolean)config.isCacheMessageAsBytes());
        Assert.assertFalse((boolean)config.isCacheMessageOriginalPayload());
        Assert.assertFalse((boolean)config.isEnableStreaming());
        Assert.assertFalse((boolean)ThreadSafeAccess.AccessControl.isAssertMessageAccess());
        Assert.assertFalse((boolean)config.isAutoWrapMessageAwareTransform());
    }
}

