/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.CompositeMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.api.transport.PropertyScope;
import org.mule.construct.Flow;
import org.mule.endpoint.DefaultInboundEndpoint;
import org.mule.source.StartableCompositeMessageSource;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transformer.simple.StringAppendTransformer;

public class FlowConfigurationFunctionalTestCase
extends FunctionalTestCase {
    public FlowConfigurationFunctionalTestCase() {
        this.setDisposeContextPerClass(true);
    }

    protected String getConfigFile() {
        return "org/mule/test/construct/flow.xml";
    }

    @Test
    public void testFlow() throws Exception {
        Flow flow = (Flow)muleContext.getRegistry().lookupObject("flow");
        Assert.assertEquals(DefaultInboundEndpoint.class, flow.getMessageSource().getClass());
        Assert.assertEquals((Object)"vm://in", (Object)((InboundEndpoint)flow.getMessageSource()).getEndpointURI().getUri().toString());
        Assert.assertEquals((long)5L, (long)flow.getMessageProcessors().size());
        Assert.assertNotNull((Object)flow.getExceptionListener());
        Assert.assertEquals((Object)"012xyzabc3", (Object)muleContext.getClient().send("vm://in", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext)).getPayloadAsString());
    }

    @Test
    public void testFlowSynchronous() throws MuleException {
        muleContext.getClient().send("vm://synchronous", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext));
        MuleMessage message = muleContext.getClient().request("vm://synchronous-out", 5000L);
        Assert.assertNotNull((Object)message);
        Thread thread = (Thread)message.getPayload();
        Assert.assertNotNull((Object)thread);
        Assert.assertEquals((Object)Thread.currentThread(), (Object)thread);
    }

    @Test
    public void testFlowAynchronous() throws MuleException {
        muleContext.getClient().send("vm://asynchronous", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext));
        MuleMessage message = muleContext.getClient().request("vm://asynchronous-out", 5000L);
        Assert.assertNotNull((Object)message);
        Thread thread = (Thread)message.getPayload();
        Assert.assertNotNull((Object)thread);
        Assert.assertNotSame((Object)Thread.currentThread(), (Object)thread);
    }

    @Test
    public void testFlowQueuedAsynchronous() throws MuleException {
        muleContext.getClient().send("vm://queued-asynchronous", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext));
        MuleMessage message = muleContext.getClient().request("vm://queued-asynchronous-out", 5000L);
        Assert.assertNotNull((Object)message);
        Thread thread = (Thread)message.getPayload();
        Assert.assertNotNull((Object)thread);
        Assert.assertNotSame((Object)Thread.currentThread(), (Object)thread);
    }

    @Test
    public void testAsyncAynchronous() throws MuleException {
        muleContext.getClient().dispatch("vm://asynchronous-async", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext));
        MuleMessage message = muleContext.getClient().request("vm://asynchronous-async-out", 5000L);
        Assert.assertNotNull((Object)message);
        Thread thread = (Thread)message.getPayload();
        Assert.assertNotNull((Object)thread);
        Assert.assertNotSame((Object)Thread.currentThread(), (Object)thread);
    }

    @Test
    public void testAsyncQueuedAsynchronous() throws MuleException {
        muleContext.getClient().dispatch("vm://queued-asynchronous-async", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext));
        MuleMessage message = muleContext.getClient().request("vm://queued-asynchronous-async-out", 5000L);
        Assert.assertNotNull((Object)message);
        Thread thread = (Thread)message.getPayload();
        Assert.assertNotNull((Object)thread);
        Assert.assertNotSame((Object)Thread.currentThread(), (Object)thread);
    }

    @Test
    public void testFlowCompositeSource() throws Exception {
        Flow flow = (Flow)muleContext.getRegistry().lookupObject("flow2");
        Assert.assertEquals(StartableCompositeMessageSource.class, flow.getMessageSource().getClass());
        Assert.assertEquals((long)2L, (long)flow.getMessageProcessors().size());
        Assert.assertEquals((Object)"01xyz", (Object)muleContext.getClient().send("vm://in2", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext)).getPayloadAsString());
        Assert.assertEquals((Object)"01xyz", (Object)muleContext.getClient().send("vm://in3", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext)).getPayloadAsString());
    }

    @Test
    public void testInOutFlow() throws Exception {
        muleContext.getClient().send("vm://inout-in", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext));
        Assert.assertEquals((Object)"0", (Object)muleContext.getClient().request("vm://inout-out", 5000L).getPayloadAsString());
    }

    @Test
    public void testInOutAppendFlow() throws Exception {
        muleContext.getClient().send("vm://inout-append-in", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext));
        Assert.assertEquals((Object)"0inout", (Object)muleContext.getClient().request("vm://inout-append-out", 5000L).getPayloadAsString());
    }

    @Test
    public void testSplitAggregateFlow() throws Exception {
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        FruitBowl fruitBowl = new FruitBowl(apple, banana);
        fruitBowl.addFruit((Fruit)orange);
        muleContext.getClient().send("vm://split-aggregate-in", (MuleMessage)new DefaultMuleMessage((Object)fruitBowl, muleContext));
        MuleMessage result = muleContext.getClient().request("vm://split-aggregate-out", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof MuleMessageCollection));
        MuleMessageCollection coll = (MuleMessageCollection)result;
        Assert.assertEquals((long)3L, (long)coll.size());
        List results = (List)coll.getPayload();
        Assert.assertTrue((boolean)apple.isBitten());
        Assert.assertTrue((boolean)banana.isBitten());
        Assert.assertTrue((boolean)orange.isBitten());
        Assert.assertTrue((boolean)results.contains(apple));
        Assert.assertTrue((boolean)results.contains(banana));
        Assert.assertTrue((boolean)results.contains(orange));
    }

    @Test
    public void testSplitNoParts() throws Exception {
        String MESSAGE = "<Order></Order>";
        MuleMessage result = muleContext.getClient().send("vm://split-no-parts-in", (Object)MESSAGE, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getPayload(), (Object)MESSAGE);
    }

    @Test
    public void testSplitAggregateListFlow() throws Exception {
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        FruitBowl fruitBowl = new FruitBowl(apple, banana);
        fruitBowl.addFruit((Fruit)orange);
        muleContext.getClient().send("vm://split-aggregate-list-in", (MuleMessage)new DefaultMuleMessage((Object)fruitBowl.getFruit(), muleContext));
        MuleMessage result = muleContext.getClient().request("vm://split-aggregate-list-out", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof MuleMessageCollection));
        MuleMessageCollection coll = (MuleMessageCollection)result;
        Assert.assertEquals((long)3L, (long)coll.size());
        List results = (List)coll.getPayload();
        Assert.assertTrue((boolean)apple.isBitten());
        Assert.assertTrue((boolean)banana.isBitten());
        Assert.assertTrue((boolean)orange.isBitten());
        Assert.assertTrue((boolean)results.contains(apple));
        Assert.assertTrue((boolean)results.contains(banana));
        Assert.assertTrue((boolean)results.contains(orange));
    }

    @Test
    public void testSplitAggregateListFlowSingleItem() throws Exception {
        Apple apple = new Apple();
        FruitBowl fruitBowl = new FruitBowl();
        fruitBowl.addFruit((Fruit)apple);
        muleContext.getClient().send("vm://split-aggregate-singleton-list-in", (MuleMessage)new DefaultMuleMessage((Object)fruitBowl.getFruit(), muleContext));
        MuleMessage result = muleContext.getClient().request("vm://split-aggregate-singleton-list-out", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof MuleMessageCollection));
        MuleMessageCollection coll = (MuleMessageCollection)result;
        Assert.assertEquals((long)1L, (long)coll.size());
        List results = (List)coll.getPayload();
        Assert.assertTrue((boolean)apple.isBitten());
        Assert.assertTrue((boolean)results.contains(apple));
    }

    @Test
    public void testSplitAggregateResponseListFlow() throws Exception {
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        FruitBowl fruitBowl = new FruitBowl(apple, banana);
        fruitBowl.addFruit((Fruit)orange);
        MuleMessage result = muleContext.getClient().send("vm://split-aggregate-response-list-in", (MuleMessage)new DefaultMuleMessage((Object)fruitBowl.getFruit(), muleContext));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof MuleMessageCollection));
        MuleMessageCollection coll = (MuleMessageCollection)result;
        Assert.assertEquals((long)3L, (long)coll.size());
        List results = (List)coll.getPayload();
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertTrue((boolean)apple.isBitten());
        Assert.assertTrue((boolean)banana.isBitten());
        Assert.assertTrue((boolean)orange.isBitten());
        Assert.assertTrue((boolean)results.contains(apple));
        Assert.assertTrue((boolean)results.contains(banana));
        Assert.assertTrue((boolean)results.contains(orange));
    }

    @Test
    public void testSplitAggregateResponseListFlowSingleItem() throws Exception {
        Apple apple = new Apple();
        FruitBowl fruitBowl = new FruitBowl();
        fruitBowl.addFruit((Fruit)apple);
        MuleMessage result = muleContext.getClient().send("vm://split-aggregate-response-singleton-list-in", (MuleMessage)new DefaultMuleMessage((Object)fruitBowl.getFruit(), muleContext));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof MuleMessageCollection));
        MuleMessageCollection coll = (MuleMessageCollection)result;
        Assert.assertEquals((long)1L, (long)coll.size());
        List results = (List)coll.getPayload();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)apple.isBitten());
        Assert.assertTrue((boolean)results.contains(apple));
    }

    @Test
    public void testSplitAggregateMapFlow() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        map.put("apple", apple);
        map.put("banana", banana);
        map.put("orange", orange);
        MuleEvent result = ((Flow)muleContext.getRegistry().lookupFlowConstruct("split-map")).process(FlowConfigurationFunctionalTestCase.getTestEvent(map));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result.getMessage() instanceof MuleMessageCollection));
        MuleMessageCollection coll = (MuleMessageCollection)result.getMessage();
        Assert.assertEquals((long)3L, (long)coll.size());
        MuleMessage[] results = coll.getMessagesAsArray();
        Assert.assertTrue((boolean)apple.isBitten());
        Assert.assertTrue((boolean)banana.isBitten());
        Assert.assertTrue((boolean)orange.isBitten());
        Assert.assertNotNull((Object)results[0].getProperty("key", PropertyScope.INVOCATION));
        Assert.assertNotNull((Object)results[1].getProperty("key", PropertyScope.INVOCATION));
        Assert.assertNotNull((Object)results[2].getProperty("key", PropertyScope.INVOCATION));
    }

    @Test
    public void testSplitFilterAggregateFlow() throws Exception {
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        FruitBowl fruitBowl = new FruitBowl(apple, banana);
        fruitBowl.addFruit((Fruit)orange);
        muleContext.getClient().send("vm://split-filter-aggregate-in", (MuleMessage)new DefaultMuleMessage((Object)fruitBowl, muleContext));
        MuleMessage result = muleContext.getClient().request("vm://split-filter-aggregate-out", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof MuleMessageCollection));
        MuleMessageCollection coll = (MuleMessageCollection)result;
        Assert.assertEquals((long)1L, (long)coll.size());
        List results = (List)coll.getPayload();
        Assert.assertTrue((boolean)results.contains(apple));
        Assert.assertFalse((boolean)results.contains(banana));
        Assert.assertFalse((boolean)results.contains(orange));
    }

    @Test
    public void testMessageChunkSplitAggregateFlow() throws Exception {
        String payload = "";
        for (int i = 0; i < 100; ++i) {
            payload = payload + "Test Message";
        }
        muleContext.getClient().send("vm://message-chunk-split-aggregate-in", (MuleMessage)new DefaultMuleMessage((Object)payload, muleContext));
        MuleMessage result = muleContext.getClient().request("vm://message-chunk-split-aggregate-out", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((Object)payload, (Object)result.getPayload());
        Assert.assertEquals((Object)payload, (Object)result.getPayloadAsString());
    }

    @Test
    public void testComponentsFlow() throws Exception {
        MuleMessage result = muleContext.getClient().send("vm://components", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((Object)"Test Messagetest", (Object)result.getPayload());
    }

    @Test
    public void testWireTapFlow() throws Exception {
        muleContext.getClient().send("vm://wiretap-in", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        MuleMessage result = muleContext.getClient().request("vm://wiretap-out", 5000L);
        MuleMessage tapResult = muleContext.getClient().request("vm://wiretap-tap", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)tapResult);
        Assert.assertNotSame((Object)result, (Object)tapResult);
        Assert.assertEquals((Object)"Test Messageinout", (Object)result.getPayloadAsString());
        Assert.assertEquals((Object)"Test Messageintap", (Object)tapResult.getPayloadAsString());
    }

    @Test
    public void testResponseElement() throws Exception {
        MuleMessage result = muleContext.getClient().send("vm://response", (MuleMessage)new DefaultMuleMessage((Object)"", muleContext));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"abcdefghi", (Object)result.getPayloadAsString());
    }

    @Test
    public void testAsyncOneWayEndpoint() throws Exception {
        muleContext.getClient().send("vm://async-oneway-in", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext));
        MuleMessage result = muleContext.getClient().request("vm://async-oneway-out", 5000L);
        MuleMessage asyncResult = muleContext.getClient().request("vm://async-async-oneway-out", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)asyncResult);
        Assert.assertEquals((Object)"0ac", (Object)result.getPayloadAsString());
        Assert.assertEquals((Object)"0ab", (Object)asyncResult.getPayloadAsString());
    }

    @Test
    public void testAsyncSedaOneWayEndpoint() throws Exception {
        muleContext.getClient().send("vm://async-seda-oneway-in", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext));
        MuleMessage result = muleContext.getClient().request("vm://async-seda-oneway-out", 5000L);
        MuleMessage asyncResult = muleContext.getClient().request("vm://async-async-seda-oneway-out", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)asyncResult);
        Assert.assertEquals((Object)"0ac", (Object)result.getPayloadAsString());
        Assert.assertEquals((Object)"0ab", (Object)asyncResult.getPayloadAsString());
    }

    @Test
    public void testAsyncRequestResponseEndpoint() throws Exception {
        muleContext.getClient().send("vm://async-requestresponse-in", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext));
        MuleMessage result = muleContext.getClient().request("vm://async-requestresponse-out", 5000L);
        MuleMessage asyncResult = muleContext.getClient().request("vm://async-async-requestresponse-out", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)asyncResult);
        Assert.assertEquals((Object)"0ac", (Object)result.getPayloadAsString());
        Assert.assertEquals((Object)"0ab", (Object)asyncResult.getPayloadAsString());
    }

    @Test
    public void testAsyncTransactionalEndpoint() throws Exception {
        MuleMessage message = muleContext.getClient().send("vm://async-tx-in", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext));
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(MessagingException.class, message.getExceptionPayload().getException().getClass());
        MuleMessage result = muleContext.getClient().request("vm://async-requestresponse-out", 5000L);
        MuleMessage asyncResult = muleContext.getClient().request("vm://async-async-oneway-out", 5000L);
        Assert.assertNull((Object)result);
        Assert.assertNull((Object)asyncResult);
    }

    @Ignore
    @Test
    public void testTransactional() throws Exception {
        muleContext.getClient().dispatch("vm://transactional-in", (MuleMessage)new DefaultMuleMessage((Object)"", muleContext));
    }

    @Ignore
    @Test
    public void testTransactionalRollback() throws Exception {
        muleContext.getClient().dispatch("vm://transactional-rollback-in", (MuleMessage)new DefaultMuleMessage((Object)"", muleContext));
    }

    @Test
    public void testMulticaster() throws Exception {
        muleContext.getClient().send("vm://multicaster-in", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        MuleMessage result1 = muleContext.getClient().request("vm://multicaster-out1", 5000L);
        MuleMessage result2 = muleContext.getClient().request("vm://multicaster-out2", 5000L);
        MuleMessage result3 = muleContext.getClient().request("vm://multicaster-out3", 5000L);
        Assert.assertNotNull((Object)result1);
        Assert.assertNotNull((Object)result2);
        Assert.assertNotNull((Object)result3);
        Assert.assertNotSame((Object)result1, (Object)result2);
        Assert.assertNotSame((Object)result1, (Object)result3);
        Assert.assertNotSame((Object)result2, (Object)result3);
        Assert.assertEquals((Object)"Test Message", (Object)result1.getPayload());
        Assert.assertEquals((Object)"Test Message", (Object)result1.getPayload());
        Assert.assertEquals((Object)"Test Message", (Object)result1.getPayload());
    }

    @Test
    public void testRecipientList() throws Exception {
        muleContext.getClient().send("vm://recipient-list-in", (MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext));
        MuleMessage result1 = muleContext.getClient().request("vm://recipient-list-out1", 5000L);
        MuleMessage result2 = muleContext.getClient().request("vm://recipient-list-out2", 5000L);
        MuleMessage result3 = muleContext.getClient().request("vm://recipient-list-out3", 5000L);
        Assert.assertNotNull((Object)result1);
        Assert.assertNotNull((Object)result2);
        Assert.assertNotNull((Object)result3);
        Assert.assertNotSame((Object)result1, (Object)result2);
        Assert.assertNotSame((Object)result1, (Object)result3);
        Assert.assertNotSame((Object)result2, (Object)result3);
        Assert.assertEquals((Object)"Test Message", (Object)result1.getPayload());
        Assert.assertEquals((Object)"Test Message", (Object)result2.getPayload());
        Assert.assertEquals((Object)"Test Message", (Object)result3.getPayload());
    }

    @Test
    public void testChoiceWithoutOutboundEndpoints() throws Exception {
        Assert.assertEquals((Object)"foo Hello foo", (Object)muleContext.getClient().send("vm://choice2-in", (MuleMessage)new DefaultMuleMessage((Object)"foo", muleContext)).getPayloadAsString());
        Assert.assertEquals((Object)"bar Hello bar", (Object)muleContext.getClient().send("vm://choice2-in", (MuleMessage)new DefaultMuleMessage((Object)"bar", muleContext)).getPayloadAsString());
        Assert.assertEquals((Object)"egh Hello ?", (Object)muleContext.getClient().send("vm://choice2-in", (MuleMessage)new DefaultMuleMessage((Object)"egh", muleContext)).getPayloadAsString());
    }

    @Test
    public void testFlowRef() throws Exception {
        Assert.assertEquals((Object)"012xyzabc312xyzabc3", (Object)muleContext.getClient().send("vm://flow-ref-in", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext)).getPayloadAsString());
    }

    @Test
    public void testInvoke() throws Exception {
        Assert.assertEquals((Object)"0recieved", (Object)muleContext.getClient().send("vm://invoke-in", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext)).getPayloadAsString());
    }

    @Test
    public void testInvoke2() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"0", muleContext);
        message.setOutboundProperty("one", (Object)"header1val");
        Assert.assertEquals((Object)"header1valrecieved", (Object)muleContext.getClient().send("vm://invoke2-in", (MuleMessage)message).getPayloadAsString());
    }

    @Test
    public void testInvoke3() throws Exception {
        muleContext.getClient().send("vm://invoke3-in", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext));
    }

    @Test
    public void testInvoke4() throws Exception {
        muleContext.getClient().send("vm://invoke4-in", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext));
    }

    @Test
    public void testEnrichWithAttributes() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"0", muleContext);
        Assert.assertEquals((Object)"0Hello", (Object)muleContext.getClient().send("vm://enrich-in", (MuleMessage)message).getProperty("helloHeader", PropertyScope.INBOUND));
    }

    @Test
    public void testEnrichWithElements() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"0", muleContext);
        MuleMessage result = muleContext.getClient().send("vm://enrich2-in", (MuleMessage)message);
        Assert.assertEquals((Object)"0Hello", (Object)result.getProperty("helloHeader", PropertyScope.INBOUND));
        Assert.assertEquals((Object)"0Hello", (Object)result.getProperty("helloHeader2", PropertyScope.INBOUND));
    }

    @Test
    public void testEnrichUsingComponent() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"0", muleContext);
        MuleMessage result = muleContext.getClient().send("vm://enrichcomponent-in", (MuleMessage)message);
        Assert.assertEquals((Object)"0", (Object)result.getProperty("echoHeader", PropertyScope.INBOUND));
    }

    @Test
    public void testEnrichUsingComponent2() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"0", muleContext);
        MuleMessage result = muleContext.getClient().send("vm://enrichcomponent2-in", (MuleMessage)message);
        Assert.assertEquals((Object)"0", (Object)result.getProperty("echoHeader", PropertyScope.INBOUND));
    }

    @Test
    public void testLoggerMessage() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"0", muleContext);
        muleContext.getClient().send("vm://loggermessage-in", (MuleMessage)message);
    }

    @Test
    public void testLoggerHeader() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"0", muleContext);
        message.setOutboundProperty("toLog", (Object)"valueToLog");
        muleContext.getClient().send("vm://loggerheader-in", (MuleMessage)message);
    }

    @Test
    public void testCustomMessageRouter() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        MuleMessage result = muleContext.getClient().send("vm://customRouter-in", (MuleMessage)message);
        Assert.assertEquals((Object)"abc", (Object)result.getPayloadAsString());
    }

    @Test
    public void testPoll() throws Exception {
        MuleMessage message = muleContext.getClient().request("vm://poll-out", 5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)" Hello fooout", (Object)message.getPayloadAsString());
    }

    @Test
    public void testPollFlowRef() throws Exception {
        MuleMessage message = muleContext.getClient().request("vm://poll2-out", 5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"pollappendout", (Object)message.getPayloadAsString());
    }

    @Test
    public void testSubFlowMessageFilter() throws Exception {
        muleContext.getClient().dispatch("vm://messagefiltersubflow-in", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext));
        MuleMessage message = muleContext.getClient().request("vm://messagefiltersubflow-out", 5000L);
        Assert.assertNotNull((Object)message);
    }

    @Test
    public void testCustomMessageSource() throws Exception {
        Flow flow = (Flow)muleContext.getRegistry().lookupFlowConstruct("customMessageSource");
        TestMessageSource source = (TestMessageSource)flow.getMessageSource();
        MuleEvent result = source.fireEvent(FlowConfigurationFunctionalTestCase.getTestEvent((Object)"a"));
        Assert.assertEquals((Object)"abcd", (Object)result.getMessageAsString());
    }

    @Test
    public void testCustomMessageSourceInComposite() throws Exception {
        Flow flow = (Flow)muleContext.getRegistry().lookupFlowConstruct("customMessageSourceInComposite");
        CompositeMessageSource compositeSource = (CompositeMessageSource)flow.getMessageSource();
        TestMessageSource source = (TestMessageSource)compositeSource.getSources().get(0);
        MuleEvent result = source.fireEvent(FlowConfigurationFunctionalTestCase.getTestEvent((Object)"a"));
        Assert.assertEquals((Object)"abcd", (Object)result.getMessageAsString());
    }

    public static class ThreadSensingMessageProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            event.getMessage().setPayload((Object)Thread.currentThread());
            return event;
        }
    }

    public static class TestMessageSource
    implements MessageSource {
        private MessageProcessor listener;
        private String appendBefore;
        private String appendAfter;

        MuleEvent fireEvent(MuleEvent event) throws MuleException {
            StringAppendTransformer before = new StringAppendTransformer(this.appendBefore);
            StringAppendTransformer after = new StringAppendTransformer(this.appendAfter);
            return after.process(this.listener.process(before.process(event)));
        }

        public void setAppendBefore(String appendBefore) {
            this.appendBefore = appendBefore;
        }

        public void setAppendAfter(String appendAfter) {
            this.appendAfter = appendAfter;
        }

        public void setListener(MessageProcessor listener) {
            this.listener = listener;
        }
    }

    public static class Pojo {
        public void method() {
        }

        public void method(Object arg1, Object arg2) {
        }
    }
}

