/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;

public class FlowRefTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/construct/flow-ref.xml";
    }

    @Test
    public void testTwoFlowRefsToSubFlow() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage msg = client.send("vm://two.flow.ref.to.sub.flow", (MuleMessage)new DefaultMuleMessage((Object)"0", muleContext));
        Assert.assertEquals((Object)"012xyzabc312xyzabc3", (Object)msg.getPayloadAsString());
    }

    @Test
    public void testDynamicFlowRef() throws Exception {
        MuleEvent eventA = FlowRefTestCase.getTestEvent((Object)"0");
        eventA.setFlowVariable("letter", (Object)"A");
        MuleEvent eventB = FlowRefTestCase.getTestEvent((Object)"0");
        eventB.setFlowVariable("letter", (Object)"B");
        Assert.assertEquals((Object)"0A", (Object)((Flow)this.getFlowConstruct("flow2")).process(eventA).getMessageAsString());
        Assert.assertEquals((Object)"0B", (Object)((Flow)this.getFlowConstruct("flow2")).process(eventB).getMessageAsString());
    }

    @Test(expected=MessagingException.class)
    public void testFlowRefNotFound() throws Exception {
        MuleEvent eventC = FlowRefTestCase.getTestEvent((Object)"0");
        eventC.setFlowVariable("letter", (Object)"C");
        Assert.assertEquals((Object)"0C", (Object)((Flow)this.getFlowConstruct("flow2")).process(eventC).getMessageAsString());
    }
}

