/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;

public abstract class OneWayOutboundTestCase
extends FunctionalTestCase {
    private LocalMuleClient client;

    @Before
    public void setUp() throws Exception {
        this.client = muleContext.getClient();
    }

    @Test
    public void noOutbound() throws Exception {
        MuleMessage response = this.client.send("vm://noOutbound", (Object)"TEST", null);
        Assert.assertEquals((Object)"TEST processed", (Object)response.getPayload());
    }

    @Test
    public void noOutboundEndpointAsync() throws Exception {
        MuleMessage response = this.client.send("vm://noOutboundAsync", (Object)"TEST", null);
        Assert.assertEquals((Object)"TEST", (Object)response.getPayload());
    }

    @Test
    public void oneWayOutbound() throws Exception {
        MuleMessage response = this.client.send("vm://oneWayOutbound", (Object)"TEST", null);
        this.assertOneWayOutboundResponse(response);
    }

    protected abstract void assertOneWayOutboundResponse(MuleMessage var1);

    @Test
    public void oneWayOutboundAfterComponent() throws Exception {
        MuleMessage response = this.client.send("vm://oneWayOutboundAfterComponent", (Object)"TEST", null);
        this.assertOneWayOutboundAfterComponentResponse(response);
    }

    protected abstract void assertOneWayOutboundAfterComponentResponse(MuleMessage var1);

    @Test
    public void oneWayOutboundBeforeComponent() throws Exception {
        MuleMessage response = this.client.send("vm://oneWayOutboundBeforeComponent", (Object)"TEST", null);
        Assert.assertEquals((Object)"TEST processed", (Object)response.getPayload());
    }
}

