/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.module.client.RemoteDispatcher;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class RemoteDispatcherTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/construct/remote-dispatcher.xml"}});
    }

    public RemoteDispatcherTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testRemoting() throws Exception {
        String[] targets = new String[]{"service1", "nosuch", "vmConnector", "flow1"};
        String[] expectedResponses = new String[]{"Hellogoodbye", null, null, "Helloaloha"};
        MuleClient client = new MuleClient(muleContext);
        RemoteDispatcher dispatcher = client.getRemoteDispatcher("http://localhost:" + this.port1.getNumber());
        for (int i = 0; i < targets.length; ++i) {
            String construct = targets[i];
            String expected = expectedResponses[i];
            MuleMessage result = dispatcher.sendToRemoteComponent(construct, (Object)"Hello", null);
            Assert.assertNotNull((Object)result);
            if (expected != null) {
                Assert.assertEquals((Object)expected, (Object)result.getPayload());
                continue;
            }
            ExceptionPayload payload = result.getExceptionPayload();
            Assert.assertNotNull((Object)payload);
            Assert.assertTrue((boolean)payload.getException().getMessage().contains(construct));
        }
    }
}

