/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration;

import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.ServerNotification;
import org.mule.construct.Flow;
import org.mule.context.notification.ClusterNodeNotification;
import org.mule.source.ClusterizableMessageSourceWrapper;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.PollingController;

public class ClusterizableMessageSourceFlowTestCase
extends FunctionalTestCase {
    public ClusterizableMessageSourceFlowTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigFile() {
        return "clusterizable-message-source-flow-config.xml";
    }

    @Test
    public void startsWhenPrimaryNode() throws Exception {
        muleContext.start();
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.request("vm://testOut", 5000L);
        Assert.assertEquals((Object)"TEST", (Object)response.getPayload());
    }

    @Test
    public void doesNotStartsWhenSecondaryNode() throws Exception {
        TestPollingController pollingController = new TestPollingController();
        ((DefaultMuleContext)muleContext).setPollingController((PollingController)pollingController);
        muleContext.start();
        Flow test1 = (Flow)muleContext.getRegistry().get("test1");
        ClusterizableMessageSourceWrapper messageSource = (ClusterizableMessageSourceWrapper)test1.getMessageSource();
        Assert.assertTrue((boolean)test1.isStarted());
        Assert.assertTrue((boolean)messageSource.isStarted());
    }

    @Test
    public void startsWhenNodeBecomePrimary() throws Exception {
        TestPollingController pollingController = new TestPollingController();
        ((DefaultMuleContext)muleContext).setPollingController((PollingController)pollingController);
        muleContext.start();
        Flow test1 = (Flow)muleContext.getRegistry().get("test1");
        ClusterizableMessageSourceWrapper messageSource = (ClusterizableMessageSourceWrapper)test1.getMessageSource();
        messageSource.initialise();
        pollingController.isPrimary = true;
        muleContext.fireNotification((ServerNotification)new ClusterNodeNotification((Object)"primary", 1701));
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.request("vm://testOut", 5000L);
        Assert.assertEquals((Object)"TEST", (Object)response.getPayload());
    }

    private class TestPollingController
    implements PollingController {
        boolean isPrimary;

        private TestPollingController() {
        }

        public boolean isPrimaryPollingInstance() {
            return this.isPrimary;
        }
    }
}

