/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration;

import java.util.concurrent.CountDownLatch;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.StartException;
import org.mule.api.lifecycle.Startable;
import org.mule.endpoint.DefaultEndpointFactory;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.util.endpoint.InboundEndpointWrapper;

public class CompositeSourceStartDelayTestCase
extends FunctionalTestCase {
    public static final CountDownLatch startLatch = new CountDownLatch(1);
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");

    public CompositeSourceStartDelayTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigFile() {
        return "composite-source-start-delay-config.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessMessageWhenAnSourceIsNotStartedYet() throws Exception {
        try {
            this.asynchronousMuleContextStart();
            PollingProber prober = new PollingProber(5000L, 50L);
            prober.check((Probe)new ProcessMessageProbe());
        }
        finally {
            startLatch.countDown();
        }
    }

    private void asynchronousMuleContextStart() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    muleContext.start();
                }
                catch (MuleException muleException) {
                    // empty catch block
                }
            }
        });
        thread.start();
    }

    public static class DelayedStartInboundEndpointWrapper
    extends InboundEndpointWrapper {
        public DelayedStartInboundEndpointWrapper(InboundEndpoint delegate) {
            super(delegate);
        }

        public void start() throws MuleException {
            try {
                startLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new StartException((Throwable)e, (Startable)this);
            }
            super.start();
        }
    }

    public static class DelayedStartEndpointFactory
    extends DefaultEndpointFactory {
        public InboundEndpoint getInboundEndpoint(EndpointBuilder builder) throws MuleException {
            InboundEndpoint endpoint = builder.buildInboundEndpoint();
            if (endpoint.getName().equals("sleepingTestIn")) {
                DelayedStartInboundEndpointWrapper wrappedEndpoint = new DelayedStartInboundEndpointWrapper(endpoint);
                return (InboundEndpoint)this.registerEndpoint((ImmutableEndpoint)wrappedEndpoint);
            }
            return (InboundEndpoint)this.registerEndpoint((ImmutableEndpoint)endpoint);
        }
    }

    private class ProcessMessageProbe
    implements Probe {
        private final HttpClient httpClient = new HttpClient();

        private ProcessMessageProbe() {
        }

        public boolean isSatisfied() {
            GetMethod method = new GetMethod("http://localhost:" + CompositeSourceStartDelayTestCase.this.httpPort.getValue());
            try {
                int statusCode = this.httpClient.executeMethod((HttpMethod)method);
                String response = method.getResponseBodyAsString();
                return 200 == statusCode && "/Processed".equals(response);
            }
            catch (Exception e) {
                return false;
            }
        }

        public String describeFailure() {
            return "Unable to process message when composite source was not completely started";
        }
    }
}

