/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration;

import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.module.xml.transformer.ObjectToXml;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.FunctionalTestCase;

public class MuleEndpointConfigurationServiceTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/test-endpoints-config-service.xml";
    }

    @Test
    public void testComponent3RouterEndpoints() throws Exception {
        Service service = muleContext.getRegistry().lookupService("TestComponent3");
        Assert.assertNotNull((Object)service);
        OutboundRouterCollection outboundRouter = (OutboundRouterCollection)service.getOutboundMessageProcessor();
        Assert.assertNotNull((Object)outboundRouter);
        Assert.assertEquals((long)2L, (long)outboundRouter.getRoutes().size());
        OutboundRouter router1 = (OutboundRouter)outboundRouter.getRoutes().get(0);
        Assert.assertEquals((long)1L, (long)router1.getRoutes().size());
        ImmutableEndpoint endpoint = (ImmutableEndpoint)router1.getRoutes().get(0);
        Assert.assertEquals((Object)"tcp", (Object)endpoint.getConnector().getProtocol().toLowerCase());
        Assert.assertEquals((Object)"tcp://localhost:60201", (Object)endpoint.getEndpointURI().getAddress());
        Assert.assertTrue((boolean)(endpoint instanceof OutboundEndpoint));
        OutboundRouter router2 = (OutboundRouter)outboundRouter.getRoutes().get(1);
        Assert.assertEquals((long)2L, (long)router2.getRoutes().size());
        endpoint = (ImmutableEndpoint)router2.getRoutes().get(0);
        Assert.assertEquals((Object)"udp", (Object)endpoint.getConnector().getProtocol().toLowerCase());
        Assert.assertEquals((Object)"udp://localhost:56731", (Object)endpoint.getEndpointURI().getAddress());
        Assert.assertTrue((boolean)(endpoint instanceof OutboundEndpoint));
        endpoint = (ImmutableEndpoint)router2.getRoutes().get(1);
        Assert.assertEquals((Object)"test", (Object)endpoint.getConnector().getProtocol().toLowerCase());
        Assert.assertEquals((Object)"test.queue2", (Object)endpoint.getEndpointURI().getAddress());
        Assert.assertTrue((boolean)(endpoint instanceof OutboundEndpoint));
    }

    @Test
    public void testComponent4InboundEndpoint() throws Exception {
        Service service = muleContext.getRegistry().lookupService("TestComponent4");
        Assert.assertNotNull((Object)service);
        Assert.assertNotNull((Object)((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoints());
        Assert.assertEquals((long)1L, (long)((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoints().size());
        ImmutableEndpoint endpoint = (ImmutableEndpoint)((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoints().get(0);
        Assert.assertNotNull((Object)endpoint);
        Assert.assertEquals((Object)"vm", (Object)endpoint.getConnector().getProtocol().toLowerCase());
        Assert.assertEquals((Object)"queue4", (Object)endpoint.getEndpointURI().getAddress());
        Assert.assertFalse((boolean)endpoint.getTransformers().isEmpty());
        Assert.assertTrue((boolean)(endpoint.getTransformers().get(0) instanceof ObjectToXml));
        Assert.assertTrue((boolean)(endpoint instanceof InboundEndpoint));
    }

    @Test
    public void testComponent4OutboundEndpoint() throws Exception {
        Service service = muleContext.getRegistry().lookupService("TestComponent4");
        Assert.assertNotNull((Object)service);
        OutboundRouterCollection outboundRouter = (OutboundRouterCollection)service.getOutboundMessageProcessor();
        Assert.assertNotNull((Object)outboundRouter);
        Assert.assertEquals((long)1L, (long)outboundRouter.getRoutes().size());
        OutboundRouter router = (OutboundRouter)outboundRouter.getRoutes().get(0);
        Assert.assertEquals((long)1L, (long)router.getRoutes().size());
        ImmutableEndpoint endpoint = (ImmutableEndpoint)router.getRoutes().get(0);
        Assert.assertEquals((Object)"udp", (Object)endpoint.getConnector().getProtocol().toLowerCase());
        Assert.assertEquals((Object)"udp://localhost:56731", (Object)endpoint.getEndpointURI().getAddress());
        Assert.assertTrue((boolean)(endpoint instanceof OutboundEndpoint));
    }

    @Test
    public void testComponent5RouterEndpoints() throws Exception {
        Service service = muleContext.getRegistry().lookupService("TestComponent5");
        Assert.assertNotNull((Object)service);
        OutboundRouterCollection outboundRouter = (OutboundRouterCollection)service.getOutboundMessageProcessor();
        Assert.assertNotNull((Object)outboundRouter);
        Assert.assertEquals((long)1L, (long)outboundRouter.getRoutes().size());
        OutboundRouter router = (OutboundRouter)outboundRouter.getRoutes().get(0);
        Assert.assertEquals((long)1L, (long)router.getRoutes().size());
        ImmutableEndpoint endpoint = (ImmutableEndpoint)router.getRoutes().get(0);
        Assert.assertEquals((Object)"tcp", (Object)endpoint.getConnector().getProtocol().toLowerCase());
        Assert.assertEquals((Object)"tcp://localhost:45431", (Object)endpoint.getEndpointURI().getAddress());
        Assert.assertTrue((boolean)(endpoint instanceof OutboundEndpoint));
    }

    @Test
    public void testEndpointFromURI() throws Exception {
        InboundEndpoint ep = muleContext.getEndpointFactory().getInboundEndpoint("test://hello?exchangePattern=request-response&responseTimeout=2002&connector=testConnector1");
        Assert.assertEquals((Object)MessageExchangePattern.REQUEST_RESPONSE, (Object)ep.getExchangePattern());
        Assert.assertEquals((long)2002L, (long)ep.getResponseTimeout());
        Assert.assertTrue((boolean)(ep instanceof InboundEndpoint));
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"hello", muleContext), ep, (FlowConstruct)MuleEndpointConfigurationServiceTestCase.getTestService(), MuleTestUtils.getTestSession((MuleContext)muleContext));
        Assert.assertEquals((long)2002L, (long)event.getTimeout());
        InboundEndpoint ep2 = muleContext.getEndpointFactory().getInboundEndpoint("test://hello?connector=testConnector1");
        event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"hello", muleContext), ep2, (FlowConstruct)MuleEndpointConfigurationServiceTestCase.getTestService(), MuleTestUtils.getTestSession((MuleContext)muleContext));
        Assert.assertEquals((long)1001L, (long)event.getTimeout());
    }
}

