/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration;

import java.io.File;
import java.io.FilenameFilter;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.Watchdog;
import org.mule.transport.file.filters.FilenameWildcardFilter;
import org.mule.util.FileUtils;

public class ServerTools {
    public static final String ACTIVEMQ_HOME = "org.activemq.home";
    private static KillableWatchdog activemq;
    private static ActiveMQConnectionFactory embeddedFactory;

    public static void launchActiveMq() {
        ServerTools.launchActiveMq("failover://tcp://localhost:61616");
    }

    public static ActiveMQConnectionFactory launchEmbeddedActiveMq() throws JMSException {
        return new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false&broker.useJmx=false");
    }

    public static void killEmbeddedActiveMq() {
        if (embeddedFactory != null) {
            embeddedFactory = null;
        }
    }

    public static void launchActiveMq(String brokerUrl) {
        int i;
        String activeMqHome = System.getProperty(ACTIVEMQ_HOME);
        if (activeMqHome == null) {
            throw new IllegalArgumentException("You must set the org.activemq.home system property to the root path of an ActiveMq distribution (v3.0 and greater) before running these tests");
        }
        Project project = new Project();
        DefaultLogger consoleLogger = new DefaultLogger();
        consoleLogger.setErrorPrintStream(System.err);
        consoleLogger.setOutputPrintStream(System.out);
        consoleLogger.setMessageOutputLevel(2);
        project.addBuildListener((BuildListener)consoleLogger);
        Path path = new Path(project);
        File[] jars = FileUtils.newFile((String)(activeMqHome + "\\lib")).listFiles((FilenameFilter)new FilenameWildcardFilter("*.jar"));
        path.add(new Path(project, FileUtils.newFile((String)activeMqHome, (String)"\\conf").getAbsolutePath()));
        for (i = 0; i < jars.length; ++i) {
            path.add(new Path(project, jars[i].getAbsolutePath()));
        }
        jars = FileUtils.newFile((String)(activeMqHome + "\\lib\\optional")).listFiles((FilenameFilter)new FilenameWildcardFilter("*.jar"));
        for (i = 0; i < jars.length; ++i) {
            path.add(new Path(project, jars[i].getAbsolutePath()));
        }
        final JavaTask java = new JavaTask();
        java.setProject(project);
        java.setClasspath(path);
        if (activeMqHome.indexOf("4.") > -1) {
            java.setClassname("org.apache.activemq.broker.Main");
        } else {
            java.setClassname("org.activemq.broker.impl.Main");
        }
        java.setArgs(brokerUrl);
        java.setFork(true);
        java.setDir(FileUtils.newFile((String)activeMqHome));
        java.addSysproperty(ServerTools.createVar("activemq.home", FileUtils.newFile((String)activeMqHome).getAbsolutePath()));
        java.addSysproperty(ServerTools.createVar("derby.system.home", FileUtils.newFile((String)activeMqHome, (String)"\\var").getAbsolutePath()));
        java.createWatchdog();
        new Thread(){

            @Override
            public void run() {
                java.execute();
            }
        }.start();
        activemq = java.watchDog;
    }

    public static void killActiveMq() {
        try {
            if (activemq != null) {
                activemq.kill();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static Environment.Variable createVar(String name, String value) {
        Environment.Variable var = new Environment.Variable();
        var.setKey(name);
        var.setValue(value);
        return var;
    }

    static {
        embeddedFactory = null;
    }

    static class KillableWatchdog
    extends ExecuteWatchdog {
        public KillableWatchdog(long timeout) {
            super(timeout);
        }

        public void timeoutOccured(Watchdog w) {
        }

        public synchronized void start(Process process) {
            super.start(process);
        }

        public void kill() {
            super.timeoutOccured(null);
        }
    }

    static class JavaTask
    extends Java {
        public KillableWatchdog watchDog;
        private Long timeout = new Long(Long.MAX_VALUE);

        JavaTask() {
        }

        public void setTimeout(Long value) {
            this.timeout = value;
            super.setTimeout(value);
        }

        protected ExecuteWatchdog createWatchdog() throws BuildException {
            if (this.watchDog == null) {
                this.watchDog = new KillableWatchdog(this.timeout != null ? this.timeout : 0L);
            }
            return this.watchDog;
        }
    }
}

