/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.client;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;

public class MuleClientJmsTestCase
extends FunctionalTestCase {
    public static final int INTERATIONS = 1;

    protected String getConfigFile() {
        return "org/mule/test/integration/client/test-client-jms-mule-config.xml";
    }

    @Test
    public void testClientSendDirect() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage message = client.sendDirect("TestReceiverUMO", null, (Object)"Test Client Send message", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Received: Test Client Send message", (Object)message.getPayload());
    }

    @Test
    public void testClientDispatchDirect() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        client.dispatchDirect("TestReceiverUMO", (Object)"Test Client dispatch message", null);
    }

    @Test
    public void testClientSend() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage message = client.send(this.getDispatchUrl(), (Object)"Test Client Send message", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Received: Test Client Send message", (Object)message.getPayload());
    }

    @Test
    public void testClientMultiSend() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        for (int i = 0; i < 1; ++i) {
            MuleMessage message = client.send(this.getDispatchUrl(), (Object)("Test Client Send message " + i), null);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)("Received: Test Client Send message " + i), (Object)message.getPayload());
        }
    }

    @Test
    public void testClientMultiDispatch() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        int i = 0;
        client.dispatch(this.getDispatchUrl(), (Object)("Test Client Send message " + i), null);
        long start = System.currentTimeMillis();
        for (i = 0; i < 1; ++i) {
            client.dispatch(this.getDispatchUrl(), (Object)("Test Client Send message " + i), null);
        }
        long time = System.currentTimeMillis() - start;
        this.logger.debug((Object)(i + " took " + time + "ms to process"));
        Thread.sleep(1000L);
    }

    @Test
    public void testClientDispatchAndReceiveOnReplyTo() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("JMSReplyTo", "replyTo.queue");
        long start = System.currentTimeMillis();
        int i = 0;
        for (i = 0; i < 1; ++i) {
            this.logger.debug((Object)("Sending message " + i));
            client.dispatch(this.getDispatchUrl(), (Object)("Test Client Dispatch message " + i), props);
        }
        long time = System.currentTimeMillis() - start;
        this.logger.debug((Object)("It took " + time + " ms to send " + i + " messages"));
        Thread.sleep(5000L);
        start = System.currentTimeMillis();
        for (i = 0; i < 1; ++i) {
            MuleMessage message = client.request("jms://replyTo.queue", 5000L);
            Assert.assertNotNull((String)"message should not be null from Reply queue", (Object)message);
            this.logger.debug((Object)("Count is " + i));
            this.logger.debug((Object)("ReplyTo Message is: " + message.getPayloadAsString()));
            Assert.assertTrue((boolean)message.getPayloadAsString().startsWith("Received"));
        }
        time = System.currentTimeMillis() - start;
        this.logger.debug((Object)("It took " + time + "ms to receive " + i + " messages"));
    }

    public String getDispatchUrl() {
        return "jms://test.queue";
    }
}

