/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.client;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.NoReceiverForEndpointException;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class MuleClientListenerTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/client/mule-client-listener-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/client/mule-client-listener-config-flow.xml"});
    }

    public MuleClientListenerTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    public void doTestRegisterListener(String component, String endpoint, boolean canSendWithoutReceiver) throws Exception {
        block6: {
            MuleClient client;
            block5: {
                client = new MuleClient(muleContext);
                try {
                    client.send(endpoint, (Object)"Test Client Send message", null);
                }
                catch (DispatchException e) {
                    if (canSendWithoutReceiver) break block5;
                    Assert.assertTrue((boolean)(e.getCause() instanceof NoReceiverForEndpointException));
                }
            }
            Object c = muleContext.getRegistry().lookupObject(component);
            if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE)) {
                ((Startable)c).start();
            }
            MuleMessage message = client.send(endpoint, (Object)"Test Client Send message", null);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)"Received: Test Client Send message", (Object)message.getPayloadAsString());
            ((Stoppable)c).stop();
            try {
                client.send(endpoint, (Object)"Test Client Send message", null);
            }
            catch (DispatchException e) {
                if (canSendWithoutReceiver) break block6;
                Assert.assertTrue((boolean)(e.getCause() instanceof NoReceiverForEndpointException));
            }
        }
    }

    @Test
    public void testRegisterListenerVm() throws Exception {
        this.doTestRegisterListener("vmComponent", "vm://test.queue", false);
    }

    @Test
    public void testRegisterListenerTcp() throws Exception {
        this.doTestRegisterListener("tcpComponent", "tcp://localhost:56324", true);
    }
}

