/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.client;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transaction.TransactionFactory;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.URIBuilder;
import org.mule.execution.TransactionalExecutionTemplate;
import org.mule.module.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.jms.JmsTransactionFactory;

public class MuleClientTransactionTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/client/test-client-jms-mule-config.xml";
    }

    @Test
    public void testTransactionsWithSetRollbackOnly() throws Exception {
        final MuleClient client = new MuleClient(muleContext);
        final HashMap<String, String> props = new HashMap<String, String>();
        props.put("JMSReplyTo", "replyTo.queue");
        props.put("MULE_REMOTE_SYNC", "false");
        while (client.request("jms://replyTo.queue", 2000L) != null) {
        }
        MuleTransactionConfig tc = new MuleTransactionConfig(1);
        tc.setFactory((TransactionFactory)new JmsTransactionFactory());
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(new URIBuilder("jms://test.queue", muleContext));
        endpointBuilder.setTransactionConfig((TransactionConfig)tc);
        endpointBuilder.setName("TransactedTest.Queue");
        OutboundEndpoint inboundEndpoint = muleContext.getEndpointFactory().getOutboundEndpoint((EndpointBuilder)endpointBuilder);
        client.getMuleContext().getRegistry().registerEndpoint((ImmutableEndpoint)inboundEndpoint);
        TransactionalExecutionTemplate executionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)muleContext, (TransactionConfig)tc);
        executionTemplate.execute((ExecutionCallback)new ExecutionCallback<Void>(){

            public Void process() throws Exception {
                for (int i = 0; i < 100; ++i) {
                    client.send("jms://test.queue", (Object)("Test Client Dispatch message " + i), props);
                }
                Transaction tx = TransactionCoordination.getInstance().getTransaction();
                Assert.assertNotNull((Object)tx);
                tx.setRollbackOnly();
                return null;
            }
        });
        MuleMessage result = client.request("jms://replyTo.queue", 2000L);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testTransactionsWithExceptionThrown() throws Exception {
        final MuleClient client = new MuleClient(muleContext);
        final HashMap<String, String> props = new HashMap<String, String>();
        props.put("JMSReplyTo", "replyTo.queue");
        props.put("MULE_REMOTE_SYNC", "false");
        while (client.request("jms://replyTo.queue", 2000L) != null) {
        }
        MuleTransactionConfig tc = new MuleTransactionConfig(1);
        tc.setFactory((TransactionFactory)new JmsTransactionFactory());
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(new URIBuilder("jms://test.queue", muleContext));
        endpointBuilder.setTransactionConfig((TransactionConfig)tc);
        endpointBuilder.setName("TransactedTest.Queue");
        OutboundEndpoint inboundEndpoint = muleContext.getEndpointFactory().getOutboundEndpoint((EndpointBuilder)endpointBuilder);
        client.getMuleContext().getRegistry().registerEndpoint((ImmutableEndpoint)inboundEndpoint);
        TransactionalExecutionTemplate executionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)muleContext, (TransactionConfig)tc);
        try {
            executionTemplate.execute((ExecutionCallback)new ExecutionCallback<Void>(){

                public Void process() throws Exception {
                    for (int i = 0; i < 100; ++i) {
                        client.send("jms://test.queue", (Object)("Test Client Dispatch message " + i), props);
                    }
                    throw new Exception();
                }
            });
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        MuleMessage result = client.request("jms://replyTo.queue", 2000L);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testTransactionsWithCommit() throws Exception {
        final MuleClient client = new MuleClient(muleContext);
        final HashMap<String, String> props = new HashMap<String, String>();
        props.put("JMSReplyTo", "replyTo.queue");
        props.put("MULE_REMOTE_SYNC", "false");
        props.put("transacted", "true");
        while (client.request("jms://replyTo.queue", 2000L) != null) {
        }
        MuleTransactionConfig tc = new MuleTransactionConfig(1);
        tc.setFactory((TransactionFactory)new JmsTransactionFactory());
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(new URIBuilder("jms://test.queue", muleContext));
        endpointBuilder.setTransactionConfig((TransactionConfig)tc);
        endpointBuilder.setName("TransactedTest.Queue");
        OutboundEndpoint inboundEndpoint = muleContext.getEndpointFactory().getOutboundEndpoint((EndpointBuilder)endpointBuilder);
        client.getMuleContext().getRegistry().registerEndpoint((ImmutableEndpoint)inboundEndpoint);
        TransactionalExecutionTemplate executionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)muleContext, (TransactionConfig)tc);
        executionTemplate.execute((ExecutionCallback)new ExecutionCallback<Void>(){

            public Void process() throws Exception {
                for (int i = 0; i < 100; ++i) {
                    client.send("jms://test.queue", (Object)("Test Client Dispatch message " + i), props);
                }
                return null;
            }
        });
        for (int i = 0; i < 100; ++i) {
            MuleMessage result = client.request("jms://replyTo.queue", 2000L);
            Assert.assertNotNull((Object)result);
        }
        MuleMessage result = client.request("jms://replyTo.queue", 2000L);
        Assert.assertNull((Object)result);
    }

    protected void emptyReplyQueue() throws Exception {
        final MuleClient client = new MuleClient(muleContext);
        MuleTransactionConfig tc = new MuleTransactionConfig(1);
        tc.setFactory((TransactionFactory)new JmsTransactionFactory());
        TransactionalExecutionTemplate executionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)muleContext, (TransactionConfig)tc);
        executionTemplate.execute((ExecutionCallback)new ExecutionCallback<Void>(){

            public Void process() throws Exception {
                while (client.request("jms://replyTo.queue", 2000L) != null) {
                }
                return null;
            }
        });
    }
}

