/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.module.client.MuleClient;
import org.mule.module.client.RemoteDispatcher;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.exceptions.FunctionalTestException;

public class RemoteExceptionTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/client/remote-exception-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/client/remote-exception-config-flow.xml"});
    }

    public RemoteExceptionTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testClientTransformerException() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        RemoteDispatcher dispatcher = client.getRemoteDispatcher("tcp://localhost:25551");
        MuleMessage result = dispatcher.sendRemote("vm://test.queue.1", (Object)new Date(), null);
        Assert.assertNotNull((Object)result);
        ExceptionPayload exceptionPayload = result.getExceptionPayload();
        Assert.assertNotNull((Object)exceptionPayload);
        Assert.assertTrue((boolean)(exceptionPayload.getException() instanceof TransformerMessagingException));
        Assert.assertTrue((boolean)(exceptionPayload.getRootException() instanceof Exception));
    }

    @Test
    public void testClientMalformedEndpointException() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        RemoteDispatcher dispatcher = client.getRemoteDispatcher("tcp://localhost:25551");
        MuleMessage result = dispatcher.sendRemote("test.queue.2", (Object)new Date(), null);
        Assert.assertNotNull((Object)result);
        ExceptionPayload exceptionPayload = result.getExceptionPayload();
        Assert.assertNotNull((Object)exceptionPayload);
        Assert.assertTrue((boolean)(exceptionPayload.getRootException() instanceof MalformedEndpointException));
    }

    @Test
    public void testClientComponentException() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        RemoteDispatcher dispatcher = client.getRemoteDispatcher("tcp://localhost:25551");
        MuleMessage result = dispatcher.sendRemote("vm://test.queue.2", (Object)new Date(), null);
        Assert.assertNotNull((Object)result);
        ExceptionPayload exceptionPayload = result.getExceptionPayload();
        Assert.assertNotNull((Object)exceptionPayload);
        Assert.assertTrue((String)exceptionPayload.getRootException().getClass().getName(), (boolean)(exceptionPayload.getRootException() instanceof FunctionalTestException));
        Assert.assertEquals((Object)"Functional Test Service Exception", (Object)exceptionPayload.getRootException().getMessage());
    }
}

