/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.components;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.client.LocalMuleClient;
import org.mule.lifecycle.AbstractLifecycleTracker;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class TransientLifecycleTrackerComponentFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/components/component-lifecycle-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/components/component-lifecycle-config-flow.xml"});
    }

    public TransientLifecycleTrackerComponentFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testSpringBeanServiceLifecycle() throws Exception {
        String expectedLifeCycle = this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW) ? "[setProperty, setMuleContext, springInitialize, start, stop, springDestroy]" : "[setProperty, setMuleContext, springInitialize, setService, start, stop, springDestroy]";
        this.testComponentLifecycle("SpringBeanService", expectedLifeCycle);
    }

    @Test
    public void testSpringBeanService2Lifecycle() throws Exception {
        String expectedLifeCycle = this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW) ? "[setProperty, setMuleContext, start, stop]" : "[setProperty, setMuleContext, setService, start, stop]";
        this.testComponentLifecycle("SpringBeanService2", expectedLifeCycle);
    }

    @Test
    public void testSingletonServiceLifecycle() throws Exception {
        String expectedLifeCycle = this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW) ? "[setProperty, setMuleContext, initialise, start, stop, dispose]" : "[setProperty, setService, setMuleContext, initialise, start, stop, dispose]";
        this.testComponentLifecycle("MuleSingletonService", expectedLifeCycle);
    }

    @Test
    public void testMulePrototypeServiceLifecycle() throws Exception {
        String expectedLifeCycle = this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW) ? "[setProperty, setMuleContext, initialise, start, stop, dispose]" : "[setProperty, setService, setMuleContext, initialise, start, stop, dispose]";
        this.testComponentLifecycle("MulePrototypeService", expectedLifeCycle);
    }

    @Test
    public void testMulePooledPrototypeServiceLifecycle() throws Exception {
        String expectedLifeCycle = this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW) ? "[setProperty, setMuleContext, initialise, start, stop, dispose]" : "[setProperty, setService, setMuleContext, initialise, start, stop, dispose]";
        this.testComponentLifecycle("MulePooledPrototypeService", expectedLifeCycle);
    }

    @Test
    public void testMulePooledSingletonServiceLifecycle() throws Exception {
        String expectedLifeCycle = this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW) ? "[setProperty, setMuleContext, initialise, initialise, initialise, start, start, start, stop, stop, stop, dispose, dispose, dispose]" : "[setProperty, setService, setMuleContext, initialise, initialise, initialise, start, start, start, stop, stop, stop, dispose, dispose, dispose]";
        this.testComponentLifecycle("MulePooledSingletonService", expectedLifeCycle);
    }

    private void testComponentLifecycle(String serviceName, String expectedLifeCycle) throws Exception {
        AbstractLifecycleTracker tracker = this.exerciseComponent(serviceName);
        muleContext.dispose();
        Assert.assertEquals((String)serviceName, (Object)expectedLifeCycle, (Object)tracker.getTracker().toString());
    }

    private AbstractLifecycleTracker exerciseComponent(String serviceName) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        AbstractLifecycleTracker ltc = (AbstractLifecycleTracker)client.send("vm://" + serviceName + ".In", null, null).getPayload();
        Assert.assertNotNull((Object)ltc);
        return ltc;
    }
}

