/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.config;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.transformer.Transformer;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.testmodels.mule.TestCompressionTransformer;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.tck.testmodels.mule.TestExceptionStrategy;
import org.mule.test.integration.config.TestFilter;

public class CustomConfigTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/config/custom-config.xml";
    }

    @Test
    public void testCustomEndpointConfig() throws Exception {
        OutboundEndpoint ep = muleContext.getEndpointFactory().getOutboundEndpoint("fooEndpoint");
        Assert.assertNotNull((String)"fooEndpoint should not be null", (Object)ep);
        TestFilter tf = (TestFilter)ep.getFilter();
        Assert.assertNotNull((String)"the filter on the endpoint should not be null", (Object)tf);
        Assert.assertEquals((Object)tf.getFoo(), (Object)"goo");
        Assert.assertEquals((long)tf.getBar(), (long)12L);
    }

    @Test
    public void testCustomConnectorConfig() throws Exception {
        TestConnector cnn = (TestConnector)muleContext.getRegistry().lookupConnector("customConnector");
        Assert.assertNotNull((String)"customConnector should not be null", (Object)cnn);
        Assert.assertEquals((Object)cnn.getSomeProperty(), (Object)"foo");
        MessagingExceptionHandler es = muleContext.getRegistry().lookupModel("main").getExceptionListener();
        Assert.assertNotNull((Object)es);
        Assert.assertTrue((boolean)(es instanceof TestExceptionStrategy));
        Assert.assertEquals((Object)"bar", (Object)((TestExceptionStrategy)es).getTestProperty());
    }

    @Test
    public void testCustomTransformerConfig() throws Exception {
        Transformer trans = muleContext.getRegistry().lookupTransformer("testTransformer");
        Assert.assertNotNull((String)"testTransformer should not be null", (Object)trans);
        Assert.assertTrue((String)"Transformer should be an instance of TestCompressionTransformer", (boolean)(trans instanceof TestCompressionTransformer));
        Assert.assertEquals((Object)((TestCompressionTransformer)trans).getBeanProperty1(), (Object)"soo");
        Assert.assertEquals((long)((TestCompressionTransformer)trans).getBeanProperty2(), (long)12345L);
    }
}

