/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transformer.Transformer;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class ResponseTransformerTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/config/response-transformer-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/config/response-transformer-test-flow.xml"});
    }

    public ResponseTransformerTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testTransformers() {
        ImmutableEndpoint endpoint = (ImmutableEndpoint)muleContext.getRegistry().lookupObject("endpoint");
        Assert.assertFalse((boolean)endpoint.getTransformers().isEmpty());
        Assert.assertEquals((long)2L, (long)endpoint.getTransformers().size());
        this.checkNames("normal", endpoint.getTransformers());
        Assert.assertFalse((boolean)endpoint.getResponseTransformers().isEmpty());
        Assert.assertEquals((long)2L, (long)endpoint.getResponseTransformers().size());
        this.checkNames("response", endpoint.getResponseTransformers());
    }

    protected void checkNames(String prefix, List<Transformer> transformers) {
        Iterator<Transformer> iterator = transformers.iterator();
        int count = 1;
        while (iterator.hasNext()) {
            Transformer transformer = iterator.next();
            this.logger.debug((Object)transformer);
            Assert.assertEquals((Object)(prefix + count), (Object)transformer.getName());
            ++count;
        }
    }
}

