/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.construct;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.concurrent.Latch;

public class BridgeTestCase
extends FunctionalTestCase {
    private static final int TIMEOUT = 5000;
    private MuleClient muleClient;

    public BridgeTestCase() {
        this.setDisposeContextPerClass(true);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.muleClient = muleContext.getClient();
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/construct/bridge-config.xml";
    }

    @Test
    public void testSynchronous() throws Exception {
        this.doTestMathsService("vm://synchronous-bridge.in");
    }

    @Test
    public void testAsynchronous() throws Exception {
        String payload = "foobar";
        MuleMessage result = this.muleClient.send("vm://asynchronous-bridge.in", (Object)"foobar", null);
        junit.framework.Assert.assertNull((Object)result);
        MuleMessage received = this.muleClient.request("vm://log-service.in", 5000L);
        Assert.assertEquals((Object)"foobar", (Object)received.getPayload());
    }

    @Test
    public void testTransformers() throws Exception {
        this.doTestStringMassager("vm://transforming-bridge.in");
    }

    @Test
    public void testEndpointReferences() throws Exception {
        this.doTestMathsService("vm://endpoint-ref-bridge.in");
    }

    @Test
    public void testChildEndpoints() throws Exception {
        this.doTestMathsService("vm://child-endpoint-bridge.in");
    }

    @Test
    public void testExceptionHandler() throws Exception {
        this.doTestMathsService("vm://exception-bridge.in");
    }

    @Test
    public void testVmTransacted() throws Exception {
        this.doTestMathsService("vm://transacted-bridge.in");
    }

    @Test
    public void testInheritance() throws Exception {
        this.doTestMathsService("vm://concrete-child-bridge.in");
    }

    @Test
    public void testHeterogeneousTransports() throws Exception {
        this.doJmsBasedTest("jms://myDlq", "dlq-file-picker");
    }

    @Test
    public void testJmsTransactions() throws Exception {
        this.doJmsBasedTest("jms://myQueue", "topic-listener");
    }

    @Test
    public void testDynamicEndpoint() throws Exception {
        Map<String, Object> properties = Collections.singletonMap("bridgeTarget", "maths-service.in");
        this.doTestMathsService("vm://child-dynamic-endpoint-bridge.in", properties);
    }

    @Test
    public void testDynamicAddress() throws Exception {
        Map<String, Object> properties = Collections.singletonMap("bridgeTarget", "maths-service.in");
        this.doTestMathsService("vm://address-dynamic-endpoint-bridge.in", properties);
    }

    private void doJmsBasedTest(String jmsDestinationUri, String ftcName) throws Exception, MuleException, InterruptedException {
        FunctionalTestComponent ftc = this.getFunctionalTestComponent(ftcName);
        final Latch latch = new Latch();
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                latch.countDown();
            }
        });
        String payload = RandomStringUtils.randomAlphabetic((int)10);
        this.muleClient.dispatch(jmsDestinationUri, (Object)payload, null);
        latch.await((long)this.getTestTimeoutSecs(), TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)ftc.getReceivedMessagesCount());
        Assert.assertEquals((Object)payload, (Object)this.byteArrayOrStringtoString(ftc.getReceivedMessage(1)));
    }

    private void doTestMathsService(String url) throws MuleException {
        this.doTestMathsService(url, null);
    }

    private void doTestMathsService(String url, Map<String, Object> messageProperties) throws MuleException {
        int a = RandomUtils.nextInt((int)100);
        int b = RandomUtils.nextInt((int)100);
        int result = (Integer)this.muleClient.send(url, (Object)new int[]{a, b}, messageProperties).getPayload();
        Assert.assertEquals((long)(a + b), (long)result);
    }

    private void doTestStringMassager(String url) throws Exception, MuleException {
        String payload = RandomStringUtils.randomAlphabetic((int)10);
        String result = this.muleClient.send(url, (Object)payload.getBytes(), null).getPayloadAsString();
        Assert.assertEquals((Object)(payload + "barbaz"), (Object)result);
    }

    private String byteArrayOrStringtoString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        return new String((byte[])o);
    }
}

