/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.classloader;

import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.listener.Callback;
import org.mule.tck.listener.FlowExecutionListener;
import org.mule.test.infrastructure.deployment.FakeMuleServer;

public class ConnectorLevelMessageDispatchingTestCase
extends AbstractMuleTestCase {
    public static final String HELLO_WORLD_APP = "hello-world";
    public static final String HELLO_MULE_APP = "hello-mule";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    @Rule
    public SystemProperty endpointScheme = new SystemProperty("scheme", "http");

    @Test
    public void verifyClassLoaderIsAppClassLoader() throws Exception {
        FakeMuleServer fakeMuleServer = new FakeMuleServer(this.temporaryFolder.getRoot().getAbsolutePath());
        fakeMuleServer.deployDomainFromClasspathFolder("domain/deployable-domains/http-connector-domain", "domain");
        fakeMuleServer.deployAppFromClasspathFolder("domain/deployable-apps/hello-world-app", HELLO_WORLD_APP);
        fakeMuleServer.deployAppFromClasspathFolder("domain/deployable-apps/hello-mule-app", HELLO_MULE_APP);
        fakeMuleServer.start();
        this.verifyAppProcessMessageWithAppClassLoader(fakeMuleServer, HELLO_MULE_APP, "http://localhost:%d/service/helloMule");
        this.verifyAppProcessMessageWithAppClassLoader(fakeMuleServer, HELLO_WORLD_APP, "http://localhost:%d/service/helloWorld");
    }

    private void verifyAppProcessMessageWithAppClassLoader(FakeMuleServer fakeMuleServer, String appName, String requestUrl) throws MuleException {
        MuleContext applicationContext = fakeMuleServer.findApplication(appName).getMuleContext();
        final AtomicReference executionClassLoader = new AtomicReference();
        FlowExecutionListener flowExecutionListener = new FlowExecutionListener(applicationContext);
        flowExecutionListener.addListener((Callback)new Callback<MuleEvent>(){

            public void execute(MuleEvent source) {
                executionClassLoader.set(Thread.currentThread().getContextClassLoader());
            }
        });
        applicationContext.getClient().send(String.format(requestUrl, this.dynamicPort.getNumber()), (Object)"test-data", null);
        flowExecutionListener.waitUntilFlowIsComplete();
        Assert.assertThat(executionClassLoader.get(), (Matcher)Is.is((Object)applicationContext.getExecutionClassLoader()));
    }
}

