/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.db;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.construct.Flow;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.DomainFunctionalTestCase;
import org.mule.tck.util.MuleDerbyTestDatabase;

@RunWith(value=Parameterized.class)
public class DbSharedConnectorTestCase
extends DomainFunctionalTestCase {
    public static final String CLIENT_APP = "client";
    public static final String SERVER_APP = "server";
    private static MuleDerbyTestDatabase derbyTestDatabase = new MuleDerbyTestDatabase("database.name");
    private final String domainConfig;

    public DbSharedConnectorTestCase(String domainConfig) {
        this.domainConfig = domainConfig;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"domain/db/db-shared-connnector.xml"}, {"domain/db/db-derby-shared-connnector.xml"});
    }

    @BeforeClass
    public static void startDatabase() throws Exception {
        derbyTestDatabase.startDatabase();
    }

    @AfterClass
    public static void stopDatabase() throws SQLException {
        derbyTestDatabase.stopDatabase();
    }

    protected String getDomainConfig() {
        return this.domainConfig;
    }

    public DomainFunctionalTestCase.ApplicationConfig[] getConfigResources() {
        return new DomainFunctionalTestCase.ApplicationConfig[]{new DomainFunctionalTestCase.ApplicationConfig((DomainFunctionalTestCase)this, CLIENT_APP, new String[]{"domain/db/db-client-app.xml"}), new DomainFunctionalTestCase.ApplicationConfig((DomainFunctionalTestCase)this, SERVER_APP, new String[]{"domain/db/db-server-app.xml"})};
    }

    @Test
    public void createJdbcRecordAndConsumeIt() throws Exception {
        MuleContext clientAppMuleContext = this.getMuleContextForApp(CLIENT_APP);
        Flow flow = (Flow)clientAppMuleContext.getRegistry().lookupFlowConstruct("dbClientService");
        flow.process(AbstractMuleContextTestCase.getTestEvent((Object)new Object(), (MuleContext)clientAppMuleContext));
        MuleMessage response = this.getMuleContextForApp(SERVER_APP).getClient().request("vm://out", 5000L);
        Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
    }
}

