/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.http;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.ApplicationContextBuilder;
import org.mule.tck.junit4.DomainContextBuilder;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpDefaultConnectorTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void defaultHttpConnectorIsNotShared() throws Exception {
        MuleContext domainContext = null;
        MuleContext firstApp = null;
        MuleContext secondApp = null;
        try {
            domainContext = new DomainContextBuilder().setDomainConfig("domain/empty-domain-config.xml").build();
            firstApp = new ApplicationContextBuilder().setDomainContext(domainContext).setApplicationResources(new String[]{"domain/http/http-hello-world-app-no-connector.xml"}).build();
            this.expectedException.expect(LifecycleException.class);
            secondApp = new ApplicationContextBuilder().setDomainContext(domainContext).setApplicationResources(new String[]{"domain/http/http-hello-mule-app-no-connector.xml"}).build();
            this.closeQuietly(domainContext);
            this.closeQuietly(firstApp);
            this.closeQuietly(secondApp);
        }
        catch (Throwable throwable) {
            this.closeQuietly(domainContext);
            this.closeQuietly(firstApp);
            this.closeQuietly(secondApp);
            throw throwable;
        }
    }

    private void closeQuietly(MuleContext context) {
        if (context != null) {
            try {
                context.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

