/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.http;

import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.transport.ConnectorException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.ApplicationContextBuilder;
import org.mule.tck.junit4.DomainContextBuilder;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpSharePortSamePathTestCase
extends AbstractMuleTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    @Rule
    public SystemProperty endpointScheme = this.getEndpointSchemeSystemProperty();

    @Test
    public void samePathDefinedInTwoAppsWithinSameDomain() throws Exception {
        MuleContext domainContext = new DomainContextBuilder().setDomainConfig("domain/http/http-shared-connector.xml").build();
        MuleContext firstAppContext = new ApplicationContextBuilder().setApplicationResources(new String[]{"domain/http/http-hello-mule-app.xml"}).setDomainContext(domainContext).build();
        ApplicationContextBuilder secondApp = new ApplicationContextBuilder();
        try {
            secondApp.setApplicationResources(new String[]{"domain/http/http-hello-mule-app.xml"}).setDomainContext(domainContext).build();
            Assert.fail((String)"Second app context start should fail");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)IsInstanceOf.instanceOf(ConnectorException.class));
        }
        firstAppContext.dispose();
    }

    public SystemProperty getEndpointSchemeSystemProperty() {
        return new SystemProperty("scheme", "http");
    }
}

