/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.http;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.DomainFunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpSharePortTestCase
extends DomainFunctionalTestCase {
    public static final String HELLO_WORLD_SERVICE_APP = "helloWorldServiceApp";
    public static final String HELLO_MULE_SERVICE_APP = "helloMuleServiceApp";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    @Rule
    public SystemProperty endpointScheme = this.getEndpointSchemeSystemProperty();

    protected String getDomainConfig() {
        return "domain/http/http-shared-connector.xml";
    }

    public DomainFunctionalTestCase.ApplicationConfig[] getConfigResources() {
        return new DomainFunctionalTestCase.ApplicationConfig[]{new DomainFunctionalTestCase.ApplicationConfig((DomainFunctionalTestCase)this, HELLO_WORLD_SERVICE_APP, new String[]{"domain/http/http-hello-world-app.xml"}), new DomainFunctionalTestCase.ApplicationConfig((DomainFunctionalTestCase)this, HELLO_MULE_SERVICE_APP, new String[]{"domain/http/http-hello-mule-app.xml"})};
    }

    @Test
    public void bothServicesBindCorrectly() throws Exception {
        MuleMessage helloWorldServiceResponse = this.getMuleContextForApp(HELLO_WORLD_SERVICE_APP).getClient().send(String.format("%s://localhost:%d/service/helloWorld", this.endpointScheme.getValue(), this.dynamicPort.getNumber()), (Object)"test-data", null);
        Assert.assertThat((Object)helloWorldServiceResponse.getPayloadAsString(), (Matcher)Is.is((Object)"hello world"));
        MuleMessage helloMuleServiceResponse = this.getMuleContextForApp(HELLO_MULE_SERVICE_APP).getClient().send(String.format("%s://localhost:%d/service/helloMule", this.endpointScheme.getValue(), this.dynamicPort.getNumber()), (Object)"test-data", null);
        Assert.assertThat((Object)helloMuleServiceResponse.getPayloadAsString(), (Matcher)Is.is((Object)"hello mule"));
    }

    protected SystemProperty getEndpointSchemeSystemProperty() {
        return new SystemProperty("scheme", "http");
    }
}

