/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.lifecycle;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.transport.Connector;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.ApplicationContextBuilder;
import org.mule.tck.junit4.DomainContextBuilder;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class AppAndDomainLifecycleTestCase
extends AbstractMuleTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    @Rule
    public SystemProperty endpointScheme = this.getEndpointSchemeSystemProperty();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void appShutdownDoesNotStopsDomainConnector() throws Exception {
        MuleContext domainContext = null;
        MuleContext firstAppContext = null;
        MuleContext secondAppContext = null;
        try {
            domainContext = new DomainContextBuilder().setDomainConfig("domain/http/http-shared-connector.xml").build();
            firstAppContext = new ApplicationContextBuilder().setApplicationResources(new String[]{"domain/http/http-hello-mule-app.xml"}).setDomainContext(domainContext).build();
            ApplicationContextBuilder secondApp = new ApplicationContextBuilder();
            secondAppContext = secondApp.setApplicationResources(new String[]{"domain/http/http-hello-world-app.xml"}).setDomainContext(domainContext).build();
            firstAppContext.stop();
            MuleMessage response = secondAppContext.getClient().send("http://localhost:" + this.dynamicPort.getNumber() + "/service/helloWorld", (Object)"test", null);
            Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
            Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)"hello world"));
            Assert.assertThat((Object)((Connector)domainContext.getRegistry().get("sharedHttpConnector")).isStarted(), (Matcher)Is.is((Object)true));
            this.closeQuietly(domainContext);
            this.closeQuietly(firstAppContext);
            this.closeQuietly(secondAppContext);
        }
        catch (Throwable throwable) {
            this.closeQuietly(domainContext);
            this.closeQuietly(firstAppContext);
            this.closeQuietly(secondAppContext);
            throw throwable;
        }
    }

    private void closeQuietly(MuleContext context) {
        if (context != null) {
            try {
                context.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SystemProperty getEndpointSchemeSystemProperty() {
        return new SystemProperty("scheme", "http");
    }
}

