/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transaction.Transaction;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transaction.TransactionCoordination;

public class CatchExceptionStrategyFlowRefTestCase
extends FunctionalTestCase {
    public static final int TIMEOUT = 5000;

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/catch-exception-strategy-flow-ref.xml";
    }

    @Test
    public void testFlowRefHandlingException() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://inExceptionBlock", (Object)"{\"userId\":\"15\"}", null, 5000L);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode actualJsonNode = mapper.readTree(response.getPayloadAsString());
        JsonNode expectedJsonNode = mapper.readTree("{\"errorMessage\":\"error processing news\",\"userId\":15,\"title\":\"News title\"}");
        Assert.assertThat((Object)actualJsonNode, (Matcher)Is.is((Object)expectedJsonNode));
    }

    @Test
    public void testFlowRefHandlingExceptionWithTransaction() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://inTxWithException", (Object)"{\"userId\":\"15\"}", null, 5000L);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode actualJsonNode = mapper.readTree(response.getPayloadAsString());
        JsonNode expectedJsonNode = mapper.readTree("{\"errorMessage\":\"error processing news\",\"userId\":15,\"title\":\"News title\"}");
        Assert.assertThat((Object)actualJsonNode, (Matcher)Is.is((Object)expectedJsonNode));
    }

    public static class VerifyTransactionNotResolvedProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            Transaction tx = TransactionCoordination.getInstance().getTransaction();
            Assert.assertThat((Object)tx, (Matcher)IsNull.notNullValue());
            Assert.assertThat((Object)tx.isRollbackOnly(), (Matcher)Is.is((Object)false));
            return event;
        }
    }
}

