/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.util.concurrent.Latch;

public class CatchExceptionStrategyTransactionTestCase
extends AbstractServiceAndFlowTestCase {
    public static final int TIMEOUT = 5000;
    public static final String MESSAGE = "any message";
    public static final int SHORT_TIMEOUT = 500;
    private Latch messageConsumed = new Latch();

    public CatchExceptionStrategyTransactionTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/exceptions/catch-exception-strategy-transaction-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/exceptions/catch-exception-strategy-transaction-flow.xml"});
    }

    @Test
    public void testSingleTransactionIsCommittedOnFailure() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener(){

            public void onNotification(ServerNotification notification) {
                CatchExceptionStrategyTransactionTestCase.this.messageConsumed.release();
            }
        });
        client.dispatch("jms://in1?connector=activeMq", (Object)MESSAGE, null);
        this.messageConsumed.await(5000L, TimeUnit.MILLISECONDS);
        this.stopFlowConstruct("singleTransactionBehavior");
        MuleMessage request = client.request("jms://in?connector=activeMq", 5000L);
        Assert.assertThat((Object)request, (Matcher)IsNull.nullValue());
    }

    @Test
    public void testXaTransactionIsCommittedOnFailure() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener(){

            public void onNotification(ServerNotification notification) {
                CatchExceptionStrategyTransactionTestCase.this.messageConsumed.release();
            }
        });
        client.dispatch("jms://in2?connector=activeMq", (Object)MESSAGE, null);
        this.messageConsumed.await(5000L, TimeUnit.MILLISECONDS);
        this.stopFlowConstruct("xaTransactionBehavior");
        MuleMessage outMessage = client.request("jms://out2?connector=activeMq", 5000L);
        Assert.assertThat((Object)outMessage, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)outMessage.getPayloadAsString(), (Matcher)Is.is((Object)MESSAGE));
        MuleMessage inMessage = client.request("jms://in2?connector=activeMq", 5000L);
        Assert.assertThat((Object)inMessage, (Matcher)IsNull.nullValue());
        MuleMessage inVmMessage = client.request("vm://vmIn2", 5000L);
        Assert.assertThat((Object)inVmMessage, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)inVmMessage.getPayloadAsString(), (Matcher)Is.is((Object)MESSAGE));
    }
}

