/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.message.ExceptionMessage;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class ExceptionListenerTestCase
extends AbstractServiceAndFlowTestCase {
    private MuleClient client;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/exceptions/exception-listener-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/exceptions/exception-listener-config-flow.xml"});
    }

    public ExceptionListenerTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.client = muleContext.getClient();
    }

    @Test
    public void testExceptionStrategyFromComponent() throws Exception {
        this.assertQueueIsEmpty("vm://error.queue");
        this.client.send("vm://component.in", (Object)"test", null);
        this.assertQueueIsEmpty("vm://component.out");
        MuleMessage message = this.client.request("vm://error.queue", 2000L);
        Assert.assertNotNull((Object)message);
        Object payload = message.getPayload();
        Assert.assertTrue((boolean)(payload instanceof ExceptionMessage));
    }

    private void assertQueueIsEmpty(String queueName) throws MuleException {
        MuleMessage message = this.client.request(queueName, 2000L);
        Assert.assertNull((Object)message);
    }
}

