/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.io.FileNotFoundException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.DefaultMuleException;
import org.mule.api.transaction.Transaction;
import org.mule.config.i18n.CoreMessages;
import org.mule.exception.DefaultSystemExceptionStrategy;
import org.mule.routing.filters.WildcardFilter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.transaction.TransactionCoordination;

public class ExceptionRollbackTestCase
extends AbstractMuleContextTestCase {
    private DefaultSystemExceptionStrategy strategy;
    private Transaction tx;

    protected void doSetUp() throws Exception {
        this.strategy = new DefaultSystemExceptionStrategy(muleContext);
        this.strategy.setCommitTxFilter(new WildcardFilter("java.io.*"));
        this.strategy.setRollbackTxFilter(new WildcardFilter("org.mule.*, javax.*"));
        this.initialiseObject(this.strategy);
        this.tx = new TestTransaction(muleContext);
        TransactionCoordination.getInstance().bindTransaction(this.tx);
    }

    protected void doTearDown() throws Exception {
        TransactionCoordination.getInstance().unbindTransaction(this.tx);
    }

    @Test
    public void testCommit() throws Exception {
        this.strategy.handleException((Exception)new FileNotFoundException());
        Assert.assertFalse((boolean)this.tx.isRolledBack());
    }

    @Test
    public void testRollback() throws Exception {
        this.strategy.handleException((Exception)new DefaultMuleException(CoreMessages.agentsRunning()));
        Assert.assertTrue((boolean)this.tx.isRolledBack());
        Assert.assertFalse((boolean)this.tx.isCommitted());
    }

    @Test
    public void testRollbackByDefault() throws Exception {
        this.strategy.handleException((Exception)new IllegalAccessException());
        Assert.assertTrue((boolean)this.tx.isRolledBack());
        Assert.assertFalse((boolean)this.tx.isCommitted());
    }
}

