/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.context.notification.MuleContextNotification;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.concurrent.Latch;

public class ExceptionStrategyConfigurationFailuresTestCase
extends AbstractMuleTestCase {
    @Test(expected=ConfigurationException.class)
    public void testNamedFlowExceptionStrategyFails() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/named-flow-exception-strategy.xml");
    }

    @Test(expected=ConfigurationException.class)
    public void testNamedServiceExceptionStrategyFails() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/named-service-exception-strategy.xml");
    }

    @Test(expected=ConfigurationException.class)
    public void testReferenceExceptionStrategyAsGlobalExceptionStrategy() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/reference-global-exception-strategy.xml");
    }

    @Test(expected=ConfigurationException.class)
    public void testChoiceExceptionStrategyCantHaveMiddleExceptionStrategyWithoutExpression() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/exception-strategy-in-choice-without-expression.xml");
    }

    @Test(expected=ConfigurationException.class)
    public void testChoiceExceptionStrategyCantHaveDefaultExceptionStrategy() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/default-exception-strategy-in-choice.xml");
    }

    @Test(expected=ConfigurationException.class)
    public void testDefaultEsFailsAsReferencedExceptionStrategy() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/default-es-as-referenced-exception-strategy.xml");
    }

    @Test(expected=ConfigurationException.class)
    public void testDefaultExceptionStrategyReferencesNonExistentExceptionStrategy() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/default-exception-strategy-reference-non-existent-es.xml");
    }

    @Test(expected=ConfigurationException.class)
    public void testDefaultExceptionStrategyReferencesExceptionStrategyWithExpression() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/default-exception-strategy-reference-has-expression.xml");
    }

    @Test(expected=ConfigurationException.class)
    public void testChoiceExceptionStrategyWithMultipleHandleRedeliveryExceptionStrategies() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/choice-exception-strategy-multiple-rollback.xml");
    }

    @Test(expected=ConfigurationException.class)
    public void testChoiceExceptionStrategyWithMultipleHandleRedeliveryExceptionStrategiesWithGlobalAndDefault() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/choice-exception-strategy-multiple-rollback-global.xml");
    }

    @Test(expected=ConfigurationException.class)
    public void testCatchExceptionStrategyWithWhenWithoutChoice() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/when-without-choice-in-catch-es.xml");
    }

    @Test(expected=ConfigurationException.class)
    public void testRollbackExceptionStrategyWithWhenWithoutChoice() throws Exception {
        this.loadConfiguration("org/mule/test/integration/exceptions/when-without-choice-in-rollback-es.xml");
    }

    private void loadConfiguration(String configuration) throws MuleException, InterruptedException {
        DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
        ArrayList<SpringXmlConfigurationBuilder> builders = new ArrayList<SpringXmlConfigurationBuilder>();
        builders.add(new SpringXmlConfigurationBuilder(configuration));
        DefaultMuleContextBuilder contextBuilder = new DefaultMuleContextBuilder();
        MuleContext muleContext = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)contextBuilder);
        final AtomicReference<Latch> contextStartedLatch = new AtomicReference<Latch>();
        contextStartedLatch.set(new Latch());
        muleContext.registerListener((ServerNotificationListener)new MuleContextNotificationListener<MuleContextNotification>(){

            public void onNotification(MuleContextNotification notification) {
                if (notification.getAction() == 104) {
                    ((Latch)contextStartedLatch.get()).countDown();
                }
            }
        });
        muleContext.start();
        ((Latch)contextStartedLatch.get()).await(20L, TimeUnit.SECONDS);
    }
}

