/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.processor.MessageProcessor;
import org.mule.message.ExceptionMessage;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.exceptions.FunctionalTestException;

public class ExceptionStrategyConstructsTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/exceptions/exception-strategy-constructs-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/exceptions/exception-strategy-constructs-config-flow.xml"});
    }

    public ExceptionStrategyConstructsTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testDefaultExceptionStrategySingleEndpoint() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://inservice2", (Object)"test", null);
        this.assertExceptionMessage(client.request("vm://modelout", 5000L));
        client.dispatch("vm://inservice1", (Object)"test", null);
        this.assertExceptionMessage(client.request("vm://service1out", 5000L));
        Assert.assertNull((Object)client.request("vm://modelout", 5000L));
        client.dispatch("vm://inflow1", (Object)"test", null);
        this.assertExceptionMessage(client.request("vm://flow1out", 5000L));
        Assert.assertNull((Object)client.request("vm://modelout", 5000L));
    }

    private void assertExceptionMessage(MuleMessage out) {
        Assert.assertNotNull((Object)out);
        Assert.assertTrue((boolean)(out.getPayload() instanceof ExceptionMessage));
        ExceptionMessage exceptionMessage = (ExceptionMessage)out.getPayload();
        Assert.assertTrue((exceptionMessage.getException().getClass() == FunctionalTestException.class || exceptionMessage.getException().getCause().getClass() == FunctionalTestException.class ? 1 : 0) != 0);
        Assert.assertEquals((Object)"test", (Object)exceptionMessage.getPayload());
    }

    public static class ExceptionThrowingProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            throw new MessagingException(event, (Throwable)new FunctionalTestException());
        }
    }
}

