/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.context.notification.TransactionNotificationListener;
import org.mule.context.notification.ExceptionNotification;
import org.mule.context.notification.TransactionNotification;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.util.concurrent.Latch;

public class ExceptionStrategyExceptionPatternTestCase
extends AbstractServiceAndFlowTestCase {
    public static final String PAYLOAD = "some text";
    public static final int TIMEOUT = 5000;
    private Latch exceptionLatch = new Latch();
    private Latch commitLatch = new Latch();
    private Latch rollbackLatch = new Latch();
    private AtomicReference<Exception> exceptionHolder = new AtomicReference();

    public ExceptionStrategyExceptionPatternTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/exceptions/exception-strategy-exception-pattern-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/exceptions/exception-strategy-exception-pattern-flow.xml"});
    }

    @Before
    public void setUp() throws Exception {
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                ExceptionStrategyExceptionPatternTestCase.this.exceptionLatch.release();
            }
        });
        FunctionalTestComponent failingFlow = this.getFunctionalTestComponent("failingFlow");
        failingFlow.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                throw (Exception)ExceptionStrategyExceptionPatternTestCase.this.exceptionHolder.get();
            }
        });
        muleContext.registerListener((ServerNotificationListener)new TransactionNotificationListener<TransactionNotification>(){

            public void onNotification(TransactionNotification notification) {
                if (notification.getAction() == 1202) {
                    ExceptionStrategyExceptionPatternTestCase.this.commitLatch.release();
                } else if (notification.getAction() == 1203) {
                    ExceptionStrategyExceptionPatternTestCase.this.rollbackLatch.release();
                }
            }
        });
    }

    @Test
    public void testThrowExceptionAndCommit() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        this.exceptionHolder.set(new IOException());
        client.dispatch("jms://in", (Object)PAYLOAD, null);
        if (!this.exceptionLatch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"exception should be thrown");
        }
        MuleMessage muleMessage = client.request("jms://out", 5000L);
        Assert.assertThat((Object)muleMessage, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testThrowExceptionAndRollback() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        this.exceptionHolder.set(new IllegalArgumentException());
        client.dispatch("jms://in", (Object)PAYLOAD, null);
        if (!this.exceptionLatch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"exception should be thrown");
        }
        MuleMessage muleMessage = client.request("jms://out", 5000L);
        Assert.assertThat((Object)muleMessage, (Matcher)IsNull.nullValue());
    }
}

