/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.filter;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class JsonSchemaValidationFilterTestCase
extends FunctionalTestCase {
    private static final String JSON_ACCEPT = "{\n  \"homeTeam\": \"BAR\",\n  \"awayTeam\": \"RMA\",\n  \"homeTeamScore\": 3,\n  \"awayTeamScore\": 0\n}";
    private static final String JSON_REJECT = "{\n  \"homeTeam\": \"BARCA\",\n  \"awayTeam\": \"RMA\",\n  \"homeTeamScore\": 3,\n  \"awayTeamScore\": 0\n}";
    private static final String JSON_BROKEN = "{\n  \"homeTeam\": BARCA\n}";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port");

    protected String getConfigFile() {
        return "json-filter-config.xml";
    }

    @Test
    public void validSchema() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("http://localhost:" + this.dynamicPort.getNumber(), (Object)JSON_ACCEPT, null);
        Assert.assertEquals((Object)"200", (Object)message.getInboundProperty("http.status"));
        Assert.assertEquals((Object)"accepted", (Object)message.getPayloadAsString());
    }

    @Test
    public void invalidSchema() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("http://localhost:" + this.dynamicPort.getNumber(), (Object)JSON_REJECT, null);
        Assert.assertEquals((Object)"200", (Object)message.getInboundProperty("http.status"));
        Assert.assertFalse((boolean)"accepted".equals(message.getPayloadAsString()));
    }

    @Test
    public void brokenJson() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("http://localhost:" + this.dynamicPort.getNumber(), (Object)JSON_BROKEN, null);
        Assert.assertEquals((Object)"200", (Object)message.getInboundProperty("http.status"));
        Assert.assertFalse((boolean)"accepted".equals(message.getPayloadAsString()));
    }
}

