/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.interceptor;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.interceptor.Interceptor;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class SharedInterceptorStackTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "shared-interceptor-stack-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "shared-interceptor-stack-flow.xml"});
    }

    public SharedInterceptorStackTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testSharedInterceptorOnServiceOne() throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://stackOne", (Object)"Test Message", null);
        Assert.assertEquals((Object)"Test Message CustomInterceptor ComponentOne", (Object)response.getPayload());
    }

    @Test
    public void testSharedInterceptorOnServiceTwo() throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://stackTwo", (Object)"Test Message", null);
        Assert.assertEquals((Object)"Test Message CustomInterceptor ComponentTwo", (Object)response.getPayload());
    }

    public static class CustomComponent {
        private String appendString;

        public String process(String input) {
            return input + this.appendString;
        }

        public void setAppendString(String string) {
            this.appendString = string;
        }
    }

    public static class CustomInterceptor
    extends AbstractInterceptingMessageProcessor
    implements Interceptor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            MuleMessage message = event.getMessage();
            String payload = message.getPayload().toString();
            message.setPayload((Object)(payload + " CustomInterceptor"));
            return this.processNext(event);
        }
    }
}

