/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.message;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.test.integration.message.AbstractPropertyScopeTestCase;

public class VmPropertyScopeTestCase
extends AbstractPropertyScopeTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/message/vm-property-scope-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/message/vm-property-scope-flow.xml"});
    }

    public VmPropertyScopeTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testRequestResponseChain() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        message.setOutboundProperty("foo", (Object)"fooValue");
        MuleMessage result = client.send("inbound2", (MuleMessage)message);
        Assert.assertEquals((Object)"test bar", (Object)result.getPayload());
        Assert.assertEquals((Object)"fooValue", (Object)result.getInboundProperty("foo4"));
    }

    @Test
    public void testOneWay() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        message.setOutboundProperty("foo", (Object)"fooValue");
        client.dispatch("vm://queueIn", (MuleMessage)message);
        MuleMessage result = client.request("vm://queueOut", 2000L);
        Assert.assertEquals((Object)"test bar", (Object)result.getPayload());
        Assert.assertEquals((Object)"fooValue", (Object)result.getInboundProperty("foo2"));
    }

    @Test
    public void testRRToOneWay() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        message.setOutboundProperty("foo", (Object)"rrfooValue");
        MuleMessage echo = client.send("vm://rrQueueIn", (MuleMessage)message);
        MuleMessage result = client.request("vm://rrQueueOut", 2000L);
        Assert.assertEquals((Object)"test baz", (Object)result.getPayload());
        Assert.assertEquals((Object)"rrfooValue", (Object)result.getInboundProperty("foo2"));
    }

    @Test
    public void testSimpleQueueAccess() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        message.setOutboundProperty("foo", (Object)"rrfooValue");
        client.dispatch("vm://notInConfig", (MuleMessage)message);
        MuleMessage result = client.request("vm://notInConfig", 2000L);
        Assert.assertEquals((Object)"test", (Object)result.getPayload());
        Assert.assertEquals((Object)"rrfooValue", (Object)result.getInboundProperty("foo"));
    }
}

