/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.messaging.meps;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.activemq.broker.BrokerService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.NullPayload;

public class InOptionalOutOutOnlyJMSTestCase
extends AbstractServiceAndFlowTestCase {
    public static final long TIMEOUT = 3000L;
    private static BrokerService broker;

    @BeforeClass
    public static void startBroker() throws Exception {
        broker = new BrokerService();
        broker.addConnector("tcp://localhost:61616");
        broker.start();
    }

    @AfterClass
    public static void stopBroker() throws Exception {
        broker.stop();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/messaging/meps/pattern_In-Optional-Out_Out-Only_JMS-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/messaging/meps/pattern_In-Optional-Out_Out-Only_JMS-flow.xml"});
    }

    public InOptionalOutOutOnlyJMSTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testExchange() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("inboundEndpoint", (Object)"some data", null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)NullPayload.getInstance(), (Object)result.getPayload());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("foo", "bar");
        result = client.send("inboundEndpoint", (Object)"some data", props, 20000L);
        Thread.sleep(200L);
        Assert.assertEquals((long)0L, (long)broker.getAdminView().getTemporaryQueues().length);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"foo header received", (Object)result.getPayload());
    }
}

