/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.models;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;

public abstract class AbstractPipelineTestCase
extends FunctionalTestCase {
    protected int getNumberOfMessages() {
        return 100;
    }

    @Test
    public void testPipelineSynchronous() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        ArrayList<MuleMessage> results = new ArrayList<MuleMessage>();
        for (int i = 0; i < this.getNumberOfMessages(); ++i) {
            MuleMessage result = client.send("component1.endpoint", (Object)"test", null);
            Assert.assertNotNull((Object)result);
            results.add(result);
        }
        Assert.assertEquals((long)results.size(), (long)this.getNumberOfMessages());
        for (MuleMessage message : results) {
            Assert.assertEquals((Object)"request received by service 3", (Object)message.getPayloadAsString());
        }
    }

    @Test
    public void testPipelineAsynchronous() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        for (int i = 0; i < this.getNumberOfMessages(); ++i) {
            client.dispatch("component1.endpoint", (Object)"test", null);
        }
        ArrayList<MuleMessage> results = new ArrayList<MuleMessage>();
        for (int i = 0; i < this.getNumberOfMessages(); ++i) {
            MuleMessage result = client.request("results.endpoint", 1000L);
            Assert.assertNotNull((Object)result);
            results.add(result);
        }
        Assert.assertEquals((long)results.size(), (long)this.getNumberOfMessages());
        for (MuleMessage message : results) {
            Assert.assertEquals((Object)"request received by service 3", (Object)message.getPayloadAsString());
        }
    }
}

