/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.resolvers;

import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.Base64;

public class DefaultEntryPointResolverSetMultithreadingTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/resolvers/default-entry-point-resolver-multithreading-test-config.xml";
    }

    public int getTestTimeoutSecs() {
        return 120;
    }

    @Test
    public void testMultithreaded() throws Exception {
        int numberOfThreads = 50;
        int requestCount = 100;
        ClientRequest[] clients = new ClientRequest[50];
        for (int i = 0; i < 50; ++i) {
            clients[i] = new ClientRequest(100);
        }
        for (ClientRequest clientRequest : clients) {
            clientRequest.start();
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        for (int i = 0; i < 50; ++i) {
            try {
                clients[i].join();
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ MuleContext access$100() {
        return muleContext;
    }

    public static class EchoBytes {
        public byte[] echo(byte[] input) {
            return input;
        }
    }

    private static class ClientRequest
    extends Thread {
        final MuleClient client = DefaultEntryPointResolverSetMultithreadingTestCase.access$100().getClient();
        int requestCount;

        private ClientRequest(int requestCount) throws MuleException {
            this.requestCount = requestCount;
        }

        @Override
        public void run() {
            byte[] payload = this.createPayload();
            while (--this.requestCount >= 0) {
                try {
                    MuleMessage outbound = this.client.send("vm://test.inbound.sync", (Object)payload, null);
                    Assert.assertNull((Object)outbound.getExceptionPayload());
                    Assert.assertNotNull((Object)outbound.getPayload());
                    byte[] bytes = null;
                    if (outbound.getPayload() instanceof byte[]) {
                        bytes = (byte[])outbound.getPayload();
                    } else if (outbound.getPayload() instanceof List) {
                        List list = (List)outbound.getPayload();
                        Assert.assertEquals((long)1L, (long)list.size());
                        Assert.assertTrue((boolean)(list.get(0) instanceof byte[]));
                        bytes = (byte[])list.get(0);
                    } else {
                        Assert.fail((String)"unexpected payload type");
                    }
                    Assert.assertEquals((Object)Base64.encodeBytes((byte[])payload), (Object)Base64.encodeBytes((byte[])bytes));
                }
                catch (Exception e) {
                    Assert.fail((String)("failed with exception: " + e));
                }
            }
        }

        private byte[] createPayload() {
            Random random = new Random();
            int size = 55;
            byte[] payload = new byte[55];
            random.nextBytes(payload);
            return payload;
        }
    }
}

