/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.FunctionalTestNotificationListener;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.concurrent.Latch;

public class WireTapCxfTestCase
extends AbstractServiceAndFlowTestCase {
    private static final Latch tapLatch = new Latch();
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/routing/wire-tap-cxf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/routing/wire-tap-cxf-flow.xml"});
    }

    public WireTapCxfTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        muleContext.registerListener((ServerNotificationListener)new FunctionalTestNotificationListener(){

            public void onNotification(ServerNotification notification) {
                tapLatch.release();
            }
        });
    }

    @Test
    public void testWireTap() throws Exception {
        String url = "http://localhost:" + this.port1.getNumber() + "/services/EchoUMO";
        String msg = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body><echo><text>foo</text></echo></soap:Body></soap:Envelope>";
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send(url, (Object)msg, null);
        Assert.assertNotNull((Object)response);
        String responseString = response.getPayloadAsString();
        Assert.assertTrue((boolean)responseString.contains("echoResponse"));
        Assert.assertFalse((boolean)responseString.contains("soap:Fault"));
        Assert.assertTrue((boolean)tapLatch.await(5000L, TimeUnit.MILLISECONDS));
    }
}

