/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.FunctionalTestNotificationListener;
import org.mule.util.concurrent.Latch;

public class WireTapTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/routing/wire-tap-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/routing/wire-tap-flow.xml"});
    }

    public WireTapTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testWireTap() throws Exception {
        final Latch receiverLatch = new Latch();
        final Latch tappedReceiver1Latch = new Latch();
        final Latch tappedReceiver2Latch = new Latch();
        muleContext.registerListener((ServerNotificationListener)new FunctionalTestNotificationListener(){

            public void onNotification(ServerNotification notification) {
                if (notification.getResourceIdentifier().equals("Receiver")) {
                    receiverLatch.countDown();
                } else if (notification.getResourceIdentifier().equals("TappedReceiver1")) {
                    tappedReceiver1Latch.countDown();
                } else if (notification.getResourceIdentifier().equals("TappedReceiver2")) {
                    tappedReceiver2Latch.countDown();
                }
            }
        });
        LocalMuleClient client = muleContext.getClient();
        client.send("vm://inbound.channel", (Object)"test", null);
        Assert.assertTrue((boolean)receiverLatch.await(3L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)tappedReceiver1Latch.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)tappedReceiver2Latch.await(1L, TimeUnit.SECONDS));
    }
}

